/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.CodeFormatFix;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeFormatCleanUp
extends AbstractCleanUp {
    public CodeFormatCleanUp() {
    }

    public CodeFormatCleanUp(Map options) {
        super(options);
    }

    @Override
    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        return false;
    }

    @Override
    public IFix createFix(IJavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean removeWhitespaces = this.isEnabled("cleanup.remove_trailing_whitespaces");
        return CodeFormatFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.format_source_code"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_all"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty"));
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        return null;
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return null;
    }

    @Override
    public Map getRequiredOptions() {
        return null;
    }

    @Override
    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.format_source_code")) {
            result.add(MultiFixMessages.CodeFormatCleanUp_description);
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            if (this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingAll_description);
            } else if (this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingNoEmpty_description);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("  function start() {}\n");
        if (this.isEnabled("cleanup.remove_trailing_whitespaces") && this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
            buf.append("\n");
        } else {
            buf.append("    \n");
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            buf.append("    function\n");
        } else {
            buf.append("    function \n");
        }
        buf.append("        stop() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        return -1;
    }

    @Override
    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }
}

