/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.AbstractFlowBorder;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.swt.graphics.Font;

public class TestBorder
extends AbstractFlowBorder {
    private Insets insets;

    public Insets getInsets(IFigure figure) {
        if (this.insets == null) {
            this.insets = new Insets();
            Dimension size = FigureUtilities.getStringExtents((String)"begin", (Font)figure.getFont());
            this.insets.left = size.width + 3 + size.height / 2;
            size = FigureUtilities.getStringExtents((String)"end", (Font)figure.getFont());
            this.insets.right = size.width + 3 + size.height / 2;
        }
        return this.insets;
    }

    public void paint(FlowFigure figure, Graphics g, Rectangle where, int sides) {
        PointList points;
        where.resize(-1, -1);
        if ((sides & 0x4000) != 0) {
            points = new PointList(5);
            points.addPoint(where.getTopLeft());
            points.addPoint(where.getTopRight().translate(-where.height / 2, 0));
            points.addPoint(where.getRight());
            points.addPoint(where.getBottomRight().translate(-where.height / 2, 0));
            points.addPoint(where.getBottomLeft());
            g.setBackgroundColor(ColorConstants.tooltipBackground);
            g.fillPolygon(points);
            g.drawPolygon(points);
            g.drawString("begin", where.x + 1, where.y);
        }
        if ((sides & 0x20000) != 0) {
            points = new PointList(5);
            points.addPoint(where.getLeft());
            points.addPoint(where.getTopLeft().translate(where.height / 2, 0));
            points.addPoint(where.getTopRight());
            points.addPoint(where.getBottomRight());
            points.addPoint(where.getBottomLeft().translate(where.height / 2, 0));
            g.setBackgroundColor(ColorConstants.tooltipBackground);
            g.fillPolygon(points);
            g.drawPolygon(points);
            g.drawString("end", where.x + where.height / 2, where.y);
        }
    }
}

