/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.launching;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.internal.launch.remote.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RemoteHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.RemoteProcessAdapter;

public class RemoteGdbLaunchDelegate
extends GdbLaunchDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath exePath = this.checkBinaryDetails(config);
        Object remoteShellProcess = null;
        if (exePath == null) return;
        String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
        RemoteHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        String gdbserverPortNumber = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
        String gdbserverCommand = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        String gdbserverOptions = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_OPTIONS, "");
        String commandArguments = gdbserverOptions + " :" + gdbserverPortNumber + " " + RemoteHelper.spaceEscapify(remoteExePath);
        String arguments = this.getProgramArguments(config);
        String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
        if (arguments != null && !arguments.isEmpty()) {
            commandArguments = commandArguments + " " + arguments;
        }
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
        final GdbLaunch l = (GdbLaunch)launch;
        IRemoteProcess remoteShell = null;
        try {
            remoteShell = RemoteHelper.execCmdInRemoteShell(config, prelaunchCmd, gdbserverCommand, commandArguments, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        }
        catch (Exception e1) {
            RemoteHelper.abort(e1.getMessage(), e1, 150);
        }
        final boolean[] gdbServerReady = new boolean[]{false};
        final Object lock = new Object();
        if (remoteShell != null) {
            try {
                remoteShellProcess = new RemoteProcessAdapter(remoteShell){

                    public synchronized void destroy() {
                        final DsfSession session = l.getSession();
                        if (session != null) {
                            try {
                                session.getExecutor().execute((Runnable)new DsfRunnable(){

                                    public void run() {
                                        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
                                        IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                                        if (control != null) {
                                            control.terminate((RequestMonitor)new ImmediateRequestMonitor());
                                        }
                                        tracker.dispose();
                                    }
                                });
                            }
                            catch (RejectedExecutionException rejectedExecutionException) {
                                // empty catch block
                            }
                        }
                        super.destroy();
                    }
                };
            }
            catch (Exception e) {
                if (remoteShellProcess != null) {
                    ((Process)remoteShellProcess).destroy();
                }
                RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
            }
            IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)remoteShellProcess, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
            IStreamsProxy streams = iProcess.getStreamsProxy();
            IStreamMonitor monitorStream = streams.getOutputStreamMonitor();
            monitorStream.addListener(new IStreamListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void streamAppended(String text, IStreamMonitor monitor) {
                    if (text.contains("Listening on port")) {
                        Object object = lock;
                        synchronized (object) {
                            gdbServerReady[0] = true;
                            lock.notifyAll();
                        }
                        monitor.removeListener((IStreamListener)this);
                    }
                }
            });
            Object object = lock;
            synchronized (object) {
                while (!gdbServerReady[0]) {
                    if (monitor.isCanceled() || iProcess.isTerminated()) {
                        if (remoteShellProcess != null) {
                            ((Process)remoteShellProcess).destroy();
                        }
                        try {
                            l.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                                public void run() {
                                    l.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                        RemoteHelper.abort(Messages.RemoteGdbLaunchDelegate_gdbserverFailedToStartErrorMessage, null, 106);
                    }
                    try {
                        lock.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", RemoteHelper.getRemoteHostname(config));
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
            wc.doSave();
        }
        try {
            try {
                super.launch(config, mode, launch, monitor);
                return;
            }
            catch (CoreException ex) {
                if (remoteShellProcess == null) throw ex;
                ((Process)remoteShellProcess).destroy();
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.launch.remote";
    }
}

