/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.datamodel;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;

@ThreadSafe
public abstract class AbstractDMVMAdapter
extends AbstractVMAdapter {
    private final DsfSession fSession;
    private boolean fRegisteredAsEventListener = false;

    public AbstractDMVMAdapter(DsfSession session) {
        this.fSession = session;
        try {
            session.getExecutor().execute(() -> {
                if (DsfSession.isSessionActive((String)this.getSession().getId())) {
                    this.getSession().addServiceEventListener((Object)this, null);
                    this.fRegisteredAsEventListener = true;
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        try {
            this.getSession().getExecutor().execute(() -> {
                if (this.fRegisteredAsEventListener && this.getSession().isActive()) {
                    this.fSession.removeServiceEventListener((Object)this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        super.dispose();
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    @DsfServiceEventHandler
    public final void eventDispatched(IDMEvent<?> event) {
        if (this.isDisposed()) {
            return;
        }
        this.handleEvent(event);
    }
}

