/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel;

import java.util.Map;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.MessagesForDebugVM;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.core.runtime.IStatus;

public class ErrorLabelText
extends LabelText {
    protected static final String PROP_ERROR_MESSAGE = "error_message";

    public ErrorLabelText() {
        this(MessagesForDebugVM.ErrorLabelText__text_format, new String[0]);
    }

    public ErrorLabelText(String formatPattern, String[] propertyNames) {
        super(formatPattern, ErrorLabelText.addErrorMessageProperty(propertyNames));
    }

    private static String[] addErrorMessageProperty(String[] propertyNames) {
        String[] newPropertyNames = new String[propertyNames.length + 1];
        System.arraycopy(propertyNames, 0, newPropertyNames, 0, propertyNames.length);
        newPropertyNames[propertyNames.length + 0] = PROP_ERROR_MESSAGE;
        return newPropertyNames;
    }

    @Override
    protected Object getPropertyValue(String propertyName, IStatus status, Map<String, Object> properties) {
        if (PROP_ERROR_MESSAGE.equals(propertyName)) {
            if (status.getChildren().length < 2) {
                return this.replaceNewlines(status.getMessage());
            }
            StringBuilder buf = new StringBuilder(status.getMessage());
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                buf.append(MessagesForDebugVM.ErrorLabelText_Error_message__text_page_break_delimiter);
                buf.append(this.replaceNewlines(childStatus.getMessage()));
                ++n2;
            }
            return buf.toString();
        }
        return super.getPropertyValue(propertyName, status, properties);
    }

    private String replaceNewlines(String message) {
        return message.replaceAll("\n", MessagesForDebugVM.ErrorLabelText_Error_message__text_page_break_delimiter);
    }

    @Override
    public boolean checkProperty(String propertyName, IStatus status, Map<String, Object> properties) {
        if (PROP_ERROR_MESSAGE.equals(propertyName)) {
            return !status.isOK();
        }
        return super.checkProperty(propertyName, status, properties);
    }
}

