/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.IRegisterGroupDescriptor;
import org.eclipse.cdt.debug.internal.ui.actions.RegisterGroupDialog;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.Messages;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRegisters2;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDsfRegisterGroupActions
extends AbstractHandler {
    private static final String BLANK_STRING = "";
    private static final String REG_GROUP_ACTION_FAILED = "Register Group Action failed\n";

    protected void addRegisterGroup(final IWorkbenchPart part, final IStructuredSelection selection) {
        try {
            final SelectionDMContext selectionContext = new SelectionDMContext(selection);
            selectionContext.fsession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters2 registersService;
                    try {
                        registersService = selectionContext.resolveService();
                    }
                    catch (CoreException e) {
                        AbstractDsfRegisterGroupActions.this.failed(e);
                        return;
                    }
                    AbstractDsfRegisterGroupActions.this.processAddRegisterGroup(part.getSite().getShell(), selectionContext, AbstractDsfRegisterGroupActions.this.resolveSelectedRegisters(selection), registersService);
                }
            });
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    protected boolean canAddRegisterGroup(IWorkbenchPart part, IStructuredSelection selection) {
        try {
            final SelectionDMContext selectionContext = new SelectionDMContext(selection);
            Query<Boolean> query = new Query<Boolean>(){

                protected void execute(DataRequestMonitor<Boolean> rm) {
                    IRegisters2 registersService;
                    try {
                        registersService = selectionContext.resolveService();
                    }
                    catch (DebugException e) {
                        rm.setData((Object)false);
                        rm.done();
                        return;
                    }
                    if (registersService != null) {
                        registersService.canAddRegisterGroup(selectionContext.fcontext, rm);
                    } else {
                        rm.setData((Object)false);
                        rm.done();
                    }
                }
            };
            selectionContext.fsession.getExecutor().execute((Runnable)query);
            return (Boolean)query.get();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return false;
    }

    protected void editRegisterGroup(final IWorkbenchPart part, IStructuredSelection selection) {
        try {
            final SelectionDMContext selectionContext = new SelectionDMContext(selection);
            selectionContext.fsession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters2 registersService;
                    try {
                        registersService = selectionContext.resolveService();
                    }
                    catch (CoreException e) {
                        AbstractDsfRegisterGroupActions.this.failed(e);
                        return;
                    }
                    AbstractDsfRegisterGroupActions.this.processEditRegisterGroup(part.getSite().getShell(), selectionContext, registersService);
                }
            });
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    protected boolean canEditRegisterGroup(IWorkbenchPart part, IStructuredSelection selection) {
        IDMContext context;
        SelectionDMContext selectionContext;
        block6: {
            selectionContext = new SelectionDMContext(selection);
            context = selectionContext.fcontext;
            if (context instanceof IRegisters.IRegisterGroupDMContext) break block6;
            return false;
        }
        try {
            Query<Boolean> query = new Query<Boolean>(){

                protected void execute(DataRequestMonitor<Boolean> rm) {
                    IRegisters2 registersService;
                    try {
                        registersService = selectionContext.resolveService();
                    }
                    catch (DebugException e) {
                        rm.setData((Object)false);
                        rm.done();
                        return;
                    }
                    if (registersService != null) {
                        registersService.canEditRegisterGroup((IRegisters.IRegisterGroupDMContext)context, rm);
                    } else {
                        rm.setData((Object)false);
                        rm.done();
                    }
                }
            };
            selectionContext.fsession.getExecutor().execute((Runnable)query);
            return (Boolean)query.get();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return false;
    }

    protected void removeRegisterGroups(IWorkbenchPart part, IStructuredSelection selection) {
        try {
            final SelectionDMContext selectionContext = new SelectionDMContext(selection);
            final IRegisters.IRegisterGroupDMContext[] groups = this.resolveSelectedGroups(selection);
            selectionContext.fsession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters2 registersService;
                    try {
                        registersService = selectionContext.resolveService();
                    }
                    catch (CoreException e) {
                        AbstractDsfRegisterGroupActions.this.failed(e);
                        return;
                    }
                    registersService.removeRegisterGroups(groups, new RequestMonitor((Executor)registersService.getExecutor(), null){});
                }
            });
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    protected boolean canRemoveRegisterGroups(IWorkbenchPart part, IStructuredSelection selection) {
        SelectionDMContext selectionContext;
        try {
            selectionContext = new SelectionDMContext(selection);
        }
        catch (DebugException e) {
            return false;
        }
        final IRegisters.IRegisterGroupDMContext[] groups = this.resolveSelectedGroups(selection);
        if (groups == null || groups.length < 1) {
            return false;
        }
        Query<Boolean> query = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                IRegisters2 regService;
                try {
                    regService = selectionContext.resolveService();
                }
                catch (DebugException e) {
                    rm.setData((Object)false);
                    rm.done();
                    return;
                }
                regService.canRemoveRegisterGroups(groups, rm);
            }
        };
        selectionContext.fsession.getExecutor().execute((Runnable)query);
        try {
            return (Boolean)query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return false;
    }

    protected void restoreDefaultGroups(IWorkbenchPart part, IStructuredSelection selection) {
        if (!this.restoreConfirmed()) {
            return;
        }
        try {
            final SelectionDMContext selectionContext = new SelectionDMContext(selection);
            selectionContext.fsession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters2 registersService;
                    try {
                        registersService = selectionContext.resolveService();
                    }
                    catch (CoreException e) {
                        AbstractDsfRegisterGroupActions.this.failed(e);
                        return;
                    }
                    registersService.restoreDefaultGroups(null, new RequestMonitor((Executor)registersService.getExecutor(), null));
                }
            });
        }
        catch (DebugException e) {
            this.failed(e);
        }
    }

    protected boolean canRestoreDefaultGroups(IWorkbenchPart part, IStructuredSelection selection) {
        SelectionDMContext selectionContext;
        try {
            selectionContext = new SelectionDMContext(selection);
        }
        catch (DebugException e) {
            return false;
        }
        Query<Boolean> query = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                IRegisters2 regService;
                try {
                    regService = selectionContext.resolveService();
                }
                catch (DebugException e) {
                    rm.setData((Object)false);
                    rm.done();
                    return;
                }
                regService.canRestoreDefaultGroups(selectionContext.fcontext, rm);
            }
        };
        selectionContext.fsession.getExecutor().execute((Runnable)query);
        try {
            return (Boolean)query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return false;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private void processAddRegisterGroup(final Shell shell, SelectionDMContext selectionContext, final IRegisters.IRegisterDMContext[] selectedRegisters, final IRegisters2 regServiceManager) {
        DsfSession session = selectionContext.fsession;
        final DsfExecutor executor = session.getExecutor();
        final IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)selectionContext.fcontext, IRunControl.IContainerDMContext.class);
        regServiceManager.getRegisters((IDMContext)contDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)executor, null){

            protected void handleSuccess() {
                final IRegisters.IRegisterDMContext[] rootRegisters = (IRegisters.IRegisterDMContext[])this.getData();
                if (rootRegisters.length < 1) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    AbstractDsfRegisterGroupActions.this.noRegisterGroupFoundErr("Add Register Group", (RequestMonitor)this);
                    return;
                }
                final IRegisters.IRegisterGroupDMContext rootGroupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)rootRegisters[0], IRegisters.IRegisterGroupDMContext.class);
                AbstractDsfRegisterGroupActions.this.getRegistersData(rootRegisters, regServiceManager, new DataRequestMonitor<IRegisters.IRegisterDMData[]>((Executor)executor, null){

                    protected void handleSuccess() {
                        final IRegisters.IRegisterDMData[] rootRegistersData = (IRegisters.IRegisterDMData[])this.getData();
                        AbstractDsfRegisterGroupActions.this.getRegistersData(selectedRegisters, regServiceManager, new DataRequestMonitor<IRegisters.IRegisterDMData[]>((Executor)executor, null){

                            protected void handleSuccess() {
                                final IRegisters.IRegisterDMData[] selectedRegistersData = (IRegisters.IRegisterDMData[])this.getData();
                                regServiceManager.getRegisterGroupData(rootGroupDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)executor, null){

                                    protected void handleSuccess() {
                                        final IRegisters.IRegisterGroupDMData rootGroupData = (IRegisters.IRegisterGroupDMData)this.getData();
                                        AbstractDsfRegisterGroupActions.this.proposeGroupName(rootRegisters, regServiceManager, new DataRequestMonitor<String>((Executor)executor, null){

                                            protected void handleSuccess() {
                                                String proposedGroupName = (String)this.getData();
                                                String rootGroupName = rootGroupData == null ? AbstractDsfRegisterGroupActions.BLANK_STRING : rootGroupData.getName();
                                                DialogRegisterProvider descriptors = AbstractDsfRegisterGroupActions.this.buildDescriptors(rootGroupName, rootRegisters, rootRegistersData, selectedRegistersData);
                                                AbstractDsfRegisterGroupActions.this.getDialogSelection(shell, proposedGroupName, descriptors.getAllRegisters(), descriptors.getcheckedRegisters(), new DataRequestMonitor<IRegisterGroupDescriptor>((Executor)executor, null){

                                                    protected void handleSuccess() {
                                                        try {
                                                            AbstractDsfRegisterGroupActions.this.addRegisterGroup(regServiceManager, (IRegisterGroupDescriptor)this.getData(), contDmc);
                                                        }
                                                        catch (CoreException e) {
                                                            AbstractDsfRegisterGroupActions.this.failed(e);
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private void noRegisterGroupFoundErr(String msgOrigin, RequestMonitor rm) {
        String message = msgOrigin + ": Unable to resolve root Group";
        Status status = new Status(4, "org.eclipse.cdt.dsf.ui", 10004, REG_GROUP_ACTION_FAILED + message, (Throwable)new Exception(message));
        DsfUIPlugin.log((IStatus)status);
        rm.setStatus((IStatus)status);
        rm.done();
    }

    private void proposeGroupName(IRegisters.IRegisterDMContext[] registers, final IRegisters2 regServiceManager, final DataRequestMonitor<String> rm) {
        assert (registers != null && registers.length > 0);
        final DsfExecutor executor = regServiceManager.getExecutor();
        if (registers != null && registers.length > 0) {
            regServiceManager.getRegisterGroups((IDMContext)registers[0], (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>((Executor)executor, null){

                protected void handleSuccess() {
                    IRegisters.IRegisterGroupDMContext[] groupsCtx = (IRegisters.IRegisterGroupDMContext[])this.getData();
                    if (!$assertionsDisabled && groupsCtx == null) {
                        throw new AssertionError();
                    }
                    final IRegisters.IRegisterGroupDMData[] groupsData = new IRegisters.IRegisterGroupDMData[groupsCtx.length];
                    final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)executor, (RequestMonitor)rm){

                        protected void handleCompleted() {
                            String unusedGroupName = Messages.ProposeGroupNameRoot + (AbstractDsfRegisterGroupActions.this.resolveGroupNameWaterMark(groupsData) + 1);
                            rm.setData((Object)unusedGroupName);
                            rm.done();
                        }
                    };
                    int i = 0;
                    while (i < groupsCtx.length) {
                        final int index = i++;
                        regServiceManager.getRegisterGroupData(groupsCtx[index], (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)executor, (RequestMonitor)crm){

                            protected void handleSuccess() {
                                groupsData[index] = (IRegisters.IRegisterGroupDMData)this.getData();
                                crm.done();
                            }
                        });
                    }
                    crm.setDoneCount(groupsCtx.length);
                }
            });
        } else {
            rm.setData((Object)Messages.DefaultRegistersGroupName);
            rm.done();
        }
    }

    private Integer resolveGroupNameWaterMark(IRegisters.IRegisterGroupDMData[] groupsData) {
        Pattern pattern = Pattern.compile("^group_(\\d*)$");
        Matcher matcher = pattern.matcher(BLANK_STRING);
        int water_mark = 0;
        IRegisters.IRegisterGroupDMData[] iRegisterGroupDMDataArray = groupsData;
        int n = groupsData.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisters.IRegisterGroupDMData groupData = iRegisterGroupDMDataArray[n2];
            String name = groupData.getName().trim().toLowerCase();
            if (matcher.reset(name).matches()) {
                String number = matcher.replaceAll("$1");
                try {
                    int nameSequence = Integer.valueOf(number);
                    if (nameSequence > water_mark) {
                        water_mark = nameSequence;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return water_mark;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private void processEditRegisterGroup(final Shell shell, final SelectionDMContext selectionContext, final IRegisters2 regServiceManager) {
        DsfSession session = selectionContext.fsession;
        final DsfExecutor executor = session.getExecutor();
        final IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)selectionContext.fcontext, IRegisters.IRegisterGroupDMContext.class);
        regServiceManager.getRegisters(selectionContext.fcontext, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)executor, null){

            protected void handleSuccess() {
                final IRegisters.IRegisterDMContext[] childRegisters = (IRegisters.IRegisterDMContext[])this.getData();
                IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)selectionContext.fcontext, IRunControl.IContainerDMContext.class);
                regServiceManager.getRegisters((IDMContext)contDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)executor, null){

                    protected void handleSuccess() {
                        final IRegisters.IRegisterDMContext[] rootRegisters = (IRegisters.IRegisterDMContext[])this.getData();
                        if (rootRegisters.length < 1) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            AbstractDsfRegisterGroupActions.this.noRegisterGroupFoundErr("Edit Register Group", (RequestMonitor)this);
                            return;
                        }
                        AbstractDsfRegisterGroupActions.this.getRegistersData(rootRegisters, regServiceManager, new DataRequestMonitor<IRegisters.IRegisterDMData[]>((Executor)executor, null){

                            protected void handleSuccess() {
                                final IRegisters.IRegisterDMData[] rootRegistersData = (IRegisters.IRegisterDMData[])this.getData();
                                AbstractDsfRegisterGroupActions.this.getRegistersData(childRegisters, regServiceManager, new DataRequestMonitor<IRegisters.IRegisterDMData[]>((Executor)executor, null){

                                    protected void handleSuccess() {
                                        final IRegisters.IRegisterDMData[] childRegisterData = (IRegisters.IRegisterDMData[])this.getData();
                                        IRegisters.IRegisterGroupDMContext rootGroupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)rootRegisters[0], IRegisters.IRegisterGroupDMContext.class);
                                        regServiceManager.getRegisterGroupData(rootGroupDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)executor, null){

                                            protected void handleSuccess() {
                                                IRegisters.IRegisterGroupDMData rootGroupData = (IRegisters.IRegisterGroupDMData)this.getData();
                                                final String rootGroupName = rootGroupData == null ? AbstractDsfRegisterGroupActions.BLANK_STRING : rootGroupData.getName();
                                                regServiceManager.getRegisterGroupData(groupDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)executor, null){

                                                    protected void handleSuccess() {
                                                        String selGroupName = ((IRegisters.IRegisterGroupDMData)this.getData()).getName();
                                                        DialogRegisterProvider descriptors = AbstractDsfRegisterGroupActions.this.buildDescriptors(rootGroupName, rootRegisters, rootRegistersData, childRegisterData);
                                                        AbstractDsfRegisterGroupActions.this.getDialogSelection(shell, selGroupName, descriptors.getAllRegisters(), descriptors.getcheckedRegisters(), new DataRequestMonitor<IRegisterGroupDescriptor>((Executor)executor, null){

                                                            protected void handleSuccess() {
                                                                try {
                                                                    AbstractDsfRegisterGroupActions.this.editRegisterGroup(groupDmc, regServiceManager, (IRegisterGroupDescriptor)this.getData());
                                                                }
                                                                catch (CoreException e) {
                                                                    AbstractDsfRegisterGroupActions.this.failed(e);
                                                                }
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private IRegisters.IRegisterGroupDMContext[] resolveSelectedGroups(IStructuredSelection selection) {
        IRegisters.IRegisterGroupDMContext[] selectedGroups = null;
        ArrayList<IRegisters.IRegisterGroupDMContext> groupList = new ArrayList<IRegisters.IRegisterGroupDMContext>();
        if (selection != null && !selection.isEmpty()) {
            for (Object element : selection) {
                IDMContext dmContext;
                if (!(element instanceof IDMVMContext) || !((dmContext = ((IDMVMContext)element).getDMContext()) instanceof IRegisters.IRegisterGroupDMContext)) continue;
                IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)dmContext;
                groupList.add(groupDmc);
            }
        }
        selectedGroups = groupList.toArray(new IRegisters.IRegisterGroupDMContext[groupList.size()]);
        return selectedGroups;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private IRegisters.IRegisterDMContext[] resolveSelectedRegisters(IStructuredSelection selection) {
        ArrayList<IRegisters.IRegisterDMContext> selectedRegistersList = new ArrayList<IRegisters.IRegisterDMContext>();
        for (Object element : selection) {
            IRegisters.IRegisterDMContext registerDmc;
            IDMVMContext regContext = null;
            if (!(element instanceof IDMVMContext) || (registerDmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)(regContext = (IDMVMContext)element).getDMContext(), IRegisters.IRegisterDMContext.class)) == null) continue;
            selectedRegistersList.add(registerDmc);
        }
        IRegisters.IRegisterDMContext[] selectedRegisters = selectedRegistersList.toArray(new IRegisters.IRegisterDMContext[selectedRegistersList.size()]);
        return selectedRegisters;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private IRegisters.IRegisterDMContext[] getRegisterContexts(IRegisterDescriptor[] registerDescriptors) throws CoreException {
        IRegisters.IRegisterDMContext[] regContexts = new IRegisters.IRegisterDMContext[registerDescriptors.length];
        int i = 0;
        while (i < registerDescriptors.length) {
            if (!(registerDescriptors[i] instanceof RegisterDescriptor)) {
                Status status = new Status(4, "org.eclipse.cdt.dsf.ui", 4, "Unexpected IRegisterDescription instance type", null);
                throw new CoreException((IStatus)status);
            }
            regContexts[i] = ((RegisterDescriptor)registerDescriptors[i]).fRegContext;
            ++i;
        }
        return regContexts;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private void getDialogSelection(Shell shell, String originalGroupName, IRegisterDescriptor[] allRegisters, IRegisterDescriptor[] checkedRegisters, DataRequestMonitor<IRegisterGroupDescriptor> rm) {
        RegisterGroupDialogRunnable dialog = new RegisterGroupDialogRunnable(shell, originalGroupName, allRegisters, checkedRegisters, rm);
        shell.getDisplay().asyncExec((Runnable)dialog);
    }

    private IRegisterGroupDescriptor createGroupDescriptor(final String groupName, final IRegisterDescriptor[] iSelectedRegisters) {
        IRegisterGroupDescriptor groupDescriptor = new IRegisterGroupDescriptor(){

            public boolean isEnabled() {
                return true;
            }

            public String getName() {
                return groupName;
            }

            public IRegisterDescriptor[] getChildren() throws CoreException {
                return iSelectedRegisters;
            }
        };
        return groupDescriptor;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private DialogRegisterProvider buildDescriptors(String groupName, IRegisters.IRegisterDMContext[] registers, IRegisters.IRegisterDMData[] registerData, IRegisters.IRegisterDMData[] checkedRegistersData) {
        assert (registers.length == registerData.length);
        ArrayList<RegisterDescriptor> checkedDescriptorsList = new ArrayList<RegisterDescriptor>();
        final RegisterDescriptor[] regDescriptors = new RegisterDescriptor[registers.length];
        HashMap<String, RegisterDescriptor> mapNameToRegDescriptor = new HashMap<String, RegisterDescriptor>();
        int i = 0;
        while (i < registers.length) {
            regDescriptors[i] = new RegisterDescriptor(groupName, registers[i], registerData[i].getName());
            mapNameToRegDescriptor.put(regDescriptors[i].getName(), regDescriptors[i]);
            ++i;
        }
        i = 0;
        while (i < checkedRegistersData.length) {
            RegisterDescriptor descriptor = (RegisterDescriptor)mapNameToRegDescriptor.get(checkedRegistersData[i].getName());
            assert (descriptor != null);
            if (descriptor != null && !checkedDescriptorsList.contains(descriptor)) {
                checkedDescriptorsList.add(descriptor);
            }
            ++i;
        }
        final RegisterDescriptor[] checkedRegDescriptors = checkedDescriptorsList.toArray(new RegisterDescriptor[checkedDescriptorsList.size()]);
        DialogRegisterProvider provider = new DialogRegisterProvider(){

            @Override
            public IRegisterDescriptor[] getcheckedRegisters() {
                return checkedRegDescriptors;
            }

            @Override
            public IRegisterDescriptor[] getAllRegisters() {
                return regDescriptors;
            }
        };
        return provider;
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private void addRegisterGroup(IRegisters2 regServiceManager, IRegisterGroupDescriptor groupDescriptor, IRunControl.IContainerDMContext contDmc) throws CoreException {
        IRegisterDescriptor[] selectedRegisters = groupDescriptor.getChildren();
        if (selectedRegisters != null) {
            String groupName = groupDescriptor.getName();
            IRegisters.IRegisterDMContext[] registers = this.getRegisterContexts(selectedRegisters);
            regServiceManager.addRegisterGroup((IDMContext)contDmc, groupName, registers, new RequestMonitor((Executor)regServiceManager.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (this.getStatus() != null && this.getStatus().getCode() == 10003) {
                        AbstractDsfRegisterGroupActions.this.notifyUser(this.getStatus().getMessage());
                    }
                }
            });
        }
    }

    @ConfinedToDsfExecutor(value="selectionContext.fsession.getExecutor()")
    private void editRegisterGroup(IRegisters.IRegisterGroupDMContext group, IRegisters2 regServiceManager, IRegisterGroupDescriptor groupDescriptor) throws CoreException {
        IRegisterDescriptor[] selectedRegisters = groupDescriptor.getChildren();
        if (selectedRegisters != null) {
            String groupName = groupDescriptor.getName();
            regServiceManager.editRegisterGroup(group, groupName, this.getRegisterContexts(selectedRegisters), new RequestMonitor((Executor)regServiceManager.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (this.getStatus() != null && this.getStatus().getCode() == 10003) {
                        AbstractDsfRegisterGroupActions.this.notifyUser(this.getStatus().getMessage());
                    }
                }
            });
        }
    }

    private void failed(Throwable e) {
        Status status = new Status(4, "org.eclipse.cdt.dsf.ui", 10004, REG_GROUP_ACTION_FAILED + e.getMessage(), e);
        DsfUIPlugin.log((IStatus)status);
    }

    private void notifyUser(String message) {
        Runnable runnable = () -> {
            Shell parent = DsfUIPlugin.getActiveWorkbenchShell();
            if (parent != null) {
                MessageDialog.openInformation((Shell)parent, (String)Messages.Information, (String)(Messages.RegisterGroupInfo + ": " + message));
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private boolean restoreConfirmed() {
        ConfirmRestoreDialog restoreDialog = new ConfirmRestoreDialog();
        Display.getDefault().syncExec((Runnable)restoreDialog);
        return restoreDialog.fRestore;
    }

    private void getRegistersData(IRegisters.IRegisterDMContext[] regDMCs, IRegisters2 regService, DataRequestMonitor<IRegisters.IRegisterDMData[]> rm) {
        final IRegisters.IRegisterDMData[] regDataArray = new IRegisters.IRegisterDMData[regDMCs.length];
        DsfExecutor executor = regService.getExecutor();
        final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)executor, (RequestMonitor)rm, (DataRequestMonitor)rm, regDataArray){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ IRegisters.IRegisterDMData[] val$regDataArray;
            {
                this.val$rm = dataRequestMonitor;
                this.val$regDataArray = iRegisterDMDataArray;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)this.val$regDataArray);
                this.val$rm.done();
            }
        };
        int i = 0;
        while (i < regDMCs.length) {
            final int index = i++;
            regService.getRegisterData(regDMCs[index], (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)executor, (RequestMonitor)crm){

                protected void handleSuccess() {
                    regDataArray[index] = (IRegisters.IRegisterDMData)this.getData();
                    crm.done();
                }
            });
        }
        crm.setDoneCount(regDMCs.length);
    }

    private class ConfirmRestoreDialog
    implements Runnable {
        private Boolean fRestore = false;

        private ConfirmRestoreDialog() {
        }

        @Override
        public void run() {
            Shell parent = DsfUIPlugin.getActiveWorkbenchShell();
            if (parent != null) {
                String title = Messages.RegisterGroupConfirmRestoreTitle;
                String message = Messages.RegisterGroupConfirmRestoreMessage;
                String[] buttonLabels = new String[]{Messages.RegisterGroupRestore, Messages.RegisterGroupRestoreCancel};
                MessageDialog dialog = new MessageDialog(parent, title, null, message, 3, buttonLabels, 0);
                int res = dialog.open();
                if (res == 0) {
                    this.fRestore = true;
                } else if (res == 1) {
                    this.fRestore = false;
                }
            }
        }
    }

    private static interface DialogRegisterProvider {
        public IRegisterDescriptor[] getAllRegisters();

        public IRegisterDescriptor[] getcheckedRegisters();
    }

    private class RegisterDescriptor
    implements IRegisterDescriptor {
        private final IRegisters.IRegisterDMContext fRegContext;
        private String fOriginalGroupName = "";
        private String fName = "";

        private RegisterDescriptor(String groupName, IRegisters.IRegisterDMContext regContext, String name) {
            this.fRegContext = regContext;
            this.fName = name;
            this.fOriginalGroupName = groupName;
        }

        public String getName() {
            return this.fName;
        }

        public String getGroupName() {
            return this.fOriginalGroupName;
        }
    }

    private class RegisterGroupDialogRunnable
    implements Runnable {
        private String fGroupName = "";
        private IRegisterDescriptor[] fSelectedRegisters = null;
        private final IRegisterDescriptor[] fallRegisters;
        private final Shell fShell;
        private final DataRequestMonitor<IRegisterGroupDescriptor> fMonitor;

        private RegisterGroupDialogRunnable(Shell shell, String groupName, IRegisterDescriptor[] allRegisters, IRegisterDescriptor[] selectedRegisters, DataRequestMonitor<IRegisterGroupDescriptor> rm) {
            this.fallRegisters = allRegisters;
            this.fSelectedRegisters = selectedRegisters;
            this.fShell = shell;
            this.fGroupName = groupName;
            this.fMonitor = rm;
        }

        @Override
        public void run() {
            RegisterGroupDialog dialog = new RegisterGroupDialog(this.fShell, this.fGroupName, this.fallRegisters, this.fSelectedRegisters);
            if (dialog.open() != 0) {
                this.fMonitor.cancel();
                return;
            }
            String groupName = dialog.getName();
            IRegisterDescriptor[] iSelectedRegisters = dialog.getDescriptors();
            IRegisterGroupDescriptor groupDescriptor = AbstractDsfRegisterGroupActions.this.createGroupDescriptor(groupName, iSelectedRegisters);
            this.fMonitor.setData((Object)groupDescriptor);
            this.fMonitor.done();
        }
    }

    private class SelectionDMContext {
        private final IDMContext fcontext;
        private final DsfSession fsession;

        private SelectionDMContext(IStructuredSelection selection) throws DebugException {
            if (!(selection.getFirstElement() instanceof IDMVMContext)) {
                this.abort("Unrecognized element from the provided register selection");
            }
            IDMVMContext context = (IDMVMContext)selection.getFirstElement();
            this.fcontext = context.getDMContext();
            String sessionId = this.fcontext.getSessionId();
            this.fsession = DsfSession.getSession((String)sessionId);
            if (this.fsession == null || !this.fsession.isActive()) {
                this.abort("Sesssion inactive");
            }
        }

        public IRegisters2 resolveService() throws DebugException {
            DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), this.fsession.getId());
            IRegisters service = (IRegisters)tracker.getService(IRegisters.class, null);
            tracker.dispose();
            if (!(service instanceof IRegisters2)) {
                this.abort("Unable to resolve IRegisters2 service");
            }
            return (IRegisters2)service;
        }

        private void abort(String message) throws DebugException {
            Status status = new Status(4, "org.eclipse.cdt.dsf.ui", 4, message, null);
            throw new DebugException((IStatus)status);
        }
    }
}

