/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.core.internal.service;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIAddressSizeInfo;
import org.eclipse.cdt.dsf.service.DsfSession;

public class LLDBMemory
extends GDBMemory {
    private IGDBControl fCommandControl;

    public LLDBMemory(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                LLDBMemory.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        requestMonitor.done();
    }

    protected void readAddressSize(final IMemory.IMemoryDMContext memContext, final DataRequestMonitor<Integer> drm) {
        CommandFactory commandFactory = this.fCommandControl.getCommandFactory();
        this.fCommandControl.queueCommand(commandFactory.createCLIAddressSize(memContext), (DataRequestMonitor)new DataRequestMonitor<CLIAddressSizeInfo>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                Integer ptrBytes = ((CLIAddressSizeInfo)this.getData()).getAddressSize();
                drm.setData((Object)(ptrBytes * LLDBMemory.this.getAddressableSize(memContext)));
                drm.done();
            }
        });
    }

    protected void readEndianness(IMemory.IMemoryDMContext memContext, DataRequestMonitor<Boolean> drm) {
        drm.setData((Object)Boolean.FALSE);
        drm.done();
    }
}

