/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.freescale.participant.builtins;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.jsoncdb.core.participant.IRawSourceFileInfoCollector;
import org.eclipse.cdt.jsoncdb.core.participant.builtins.IBuiltinsOutputProcessor;

public final class FreescaleOutputProcessor
implements IBuiltinsOutputProcessor {
    private static final OutputLineProcessor[] macros = new OutputLineProcessor[]{new OutputLineProcessor("#define\\s+(\\S+)\\s*(.*)", 1, 2, false, 0), new OutputLineProcessor("#define\\s+(\\S+)\\(.*?\\)\\s*(.*)", 1, 2, false, 0)};

    public void processLine(String line, IRawSourceFileInfoCollector infoCollector) {
        OutputLineProcessor[] outputLineProcessorArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            OutputLineProcessor processor = outputLineProcessorArray[n2];
            Optional<ICLanguageSettingEntry> result = processor.process(line);
            if (result.isPresent()) {
                ICLanguageSettingEntry settingEntry = result.get();
                infoCollector.addDefine(settingEntry.getName(), settingEntry.getValue());
                return;
            }
            ++n2;
        }
    }

    private static class OutputLineProcessor {
        private final Pattern pattern;
        private final int nameGroup;
        private final int valueGroup;
        private final int kind;
        private final int extraFlag;

        public OutputLineProcessor(String pattern, int nameGroup, int valueGroup, boolean isIncludePath, int extraFlag) {
            this.pattern = Pattern.compile(pattern);
            this.nameGroup = nameGroup;
            this.valueGroup = valueGroup;
            this.kind = isIncludePath ? 1 : 4;
            this.extraFlag = extraFlag;
        }

        protected Optional<ICLanguageSettingEntry> process(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                String name = matcher.group(this.nameGroup);
                String value = this.valueGroup == -1 ? null : matcher.group(this.valueGroup);
                return Optional.of((ICLanguageSettingEntry)CDataUtil.createEntry((int)this.kind, (String)name, (String)value, null, (int)(3 | this.extraFlag)));
            }
            return Optional.empty();
        }
    }
}

