/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.TopLevelExceptionPlaceholder;

public class ExceptionReplacingObjectOutputStream
extends ObjectOutputStream {
    private Function<Object, Object> objectTransformer = obj -> {
        try {
            return this.doReplaceObject(obj);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    };

    public ExceptionReplacingObjectOutputStream(OutputStream outputSteam) throws IOException {
        super(outputSteam);
        this.enableReplaceObject(true);
    }

    public final Function<OutputStream, ExceptionReplacingObjectOutputStream> getObjectOutputStreamCreator() {
        return outputStream -> {
            try {
                return this.createNewInstance((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        };
    }

    protected ExceptionReplacingObjectOutputStream createNewInstance(OutputStream outputStream) throws IOException {
        return new ExceptionReplacingObjectOutputStream(outputStream);
    }

    @Override
    protected final Object replaceObject(Object obj) throws IOException {
        return this.getObjectTransformer().apply(obj);
    }

    protected Object doReplaceObject(Object obj) throws IOException {
        if (obj instanceof Throwable) {
            return new TopLevelExceptionPlaceholder((Throwable)obj, this.getObjectOutputStreamCreator());
        }
        return obj;
    }

    public Function<Object, Object> getObjectTransformer() {
        return this.objectTransformer;
    }

    public void setObjectTransformer(Function<Object, Object> objectTransformer) {
        this.objectTransformer = objectTransformer;
    }
}

