/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class ExceptionInfo {
    private final IJavaElement fElement;
    private final ITypeBinding fTypeBinding;
    private int fKind;
    public static final int OLD = 0;
    public static final int ADDED = 1;
    public static final int DELETED = 2;

    public ExceptionInfo(IJavaElement element, int kind, ITypeBinding binding) {
        Assert.isNotNull((Object)element);
        Assert.isTrue((element instanceof IType || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fKind = kind;
        this.fTypeBinding = binding;
    }

    public static ExceptionInfo createInfoForOldException(IJavaElement element, ITypeBinding binding) {
        return new ExceptionInfo(element, 0, binding);
    }

    public static ExceptionInfo createInfoForAddedException(IType type) {
        return new ExceptionInfo((IJavaElement)type, 1, null);
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fKind = 2;
    }

    public void markAsOld() {
        Assert.isTrue((boolean)this.isDeleted());
        this.fKind = 0;
    }

    public boolean isAdded() {
        return this.fKind == 1;
    }

    public boolean isDeleted() {
        return this.fKind == 2;
    }

    public boolean isOld() {
        return this.fKind == 0;
    }

    public IJavaElement getElement() {
        return this.fElement;
    }

    public String getFullyQualifiedName() {
        return this.fElement instanceof IType ? ((IType)this.fElement).getFullyQualifiedName('.') : this.fElement.getElementName();
    }

    public int getKind() {
        return this.fKind;
    }

    public ITypeBinding getTypeBinding() {
        return this.fTypeBinding;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        switch (this.fKind) {
            case 0: {
                result.append("OLD: ");
                break;
            }
            case 1: {
                result.append("ADDED: ");
                break;
            }
            case 2: {
                result.append("DELETED: ");
            }
        }
        if (this.fElement == null) {
            result.append("null");
        } else {
            result.append(this.fElement.toString());
        }
        return result.toString();
    }
}

