/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.managers;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.BuildTargetCapabilities;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.JvmBuildTarget;
import ch.epfl.scala.bsp4j.ScalaBuildTarget;
import ch.epfl.scala.bsp4j.ScalaPlatform;
import ch.epfl.scala.bsp4j.extended.JvmBuildTargetEx;
import com.microsoft.java.bs.core.internal.model.GradleBuildTarget;
import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.GradleSourceSets;
import com.microsoft.java.bs.gradle.model.JavaExtension;
import com.microsoft.java.bs.gradle.model.ScalaExtension;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import com.microsoft.java.bs.gradle.model.impl.DefaultBuildTargetDependency;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BuildTargetManager {
    private volatile Map<BuildTargetIdentifier, GradleBuildTarget> cache = new HashMap<BuildTargetIdentifier, GradleBuildTarget>();

    public List<BuildTargetIdentifier> store(GradleSourceSets gradleSourceSets) {
        HashMap<BuildTargetIdentifier, GradleBuildTarget> newCache = new HashMap<BuildTargetIdentifier, GradleBuildTarget>();
        HashMap<BuildTargetDependency, BuildTargetIdentifier> dependencyToBuildTargetId = new HashMap<BuildTargetDependency, BuildTargetIdentifier>();
        LinkedList<BuildTargetIdentifier> changedTargets = new LinkedList<BuildTargetIdentifier>();
        for (GradleSourceSet sourceSet : gradleSourceSets.getGradleSourceSets()) {
            String sourceSetName = sourceSet.getSourceSetName();
            URI uri = this.getBuildTargetUri(sourceSet.getProjectDir().toURI(), sourceSetName);
            List<String> tags = this.getBuildTargetTags(sourceSet.hasTests());
            BuildTargetIdentifier btId = new BuildTargetIdentifier(uri.toString());
            LinkedList languages = new LinkedList(sourceSet.getExtensions().keySet());
            BuildTargetCapabilities buildTargetCapabilities = new BuildTargetCapabilities();
            buildTargetCapabilities.setCanCompile(Boolean.valueOf(true));
            buildTargetCapabilities.setCanTest(Boolean.valueOf(true));
            BuildTarget bt = new BuildTarget(btId, tags, languages, Collections.emptyList(), buildTargetCapabilities);
            bt.setBaseDirectory(sourceSet.getRootDir().toURI().toString());
            bt.setDisplayName(sourceSet.getDisplayName());
            this.setBuildTarget(sourceSet, bt);
            GradleBuildTarget buildTarget = new GradleBuildTarget(bt, sourceSet);
            GradleBuildTarget existingTarget = this.cache.get(btId);
            if (existingTarget != null && !Objects.equals(existingTarget.getSourceSet(), buildTarget.getSourceSet())) {
                changedTargets.add(btId);
            }
            newCache.put(btId, buildTarget);
            DefaultBuildTargetDependency dependency = new DefaultBuildTargetDependency(sourceSet);
            dependencyToBuildTargetId.put((BuildTargetDependency)dependency, btId);
        }
        this.updateBuildTargetDependencies(newCache.values(), dependencyToBuildTargetId);
        this.cache = newCache;
        return changedTargets;
    }

    public GradleBuildTarget getGradleBuildTarget(BuildTargetIdentifier buildTargetId) {
        return this.cache.get(buildTargetId);
    }

    public List<GradleBuildTarget> getAllGradleBuildTargets() {
        return new ArrayList<GradleBuildTarget>(this.cache.values());
    }

    private URI getBuildTargetUri(URI projectUri, String sourceSetName) {
        return URI.create(projectUri.toString() + "?sourceset=" + sourceSetName);
    }

    private List<String> getBuildTargetTags(boolean hasTests) {
        ArrayList<String> tags = new ArrayList<String>();
        if (hasTests) {
            tags.add("test");
        }
        return tags;
    }

    private void setBuildTarget(GradleSourceSet sourceSet, BuildTarget bt) {
        ScalaExtension scalaExtension = (ScalaExtension)SupportedLanguages.SCALA.getExtension(sourceSet);
        JavaExtension javaExtension = (JavaExtension)SupportedLanguages.JAVA.getExtension(sourceSet);
        if (scalaExtension != null) {
            this.setScalaBuildTarget(sourceSet, scalaExtension, javaExtension, bt);
        } else if (javaExtension != null) {
            this.setJvmBuildTarget(sourceSet, javaExtension, bt);
        }
    }

    private JvmBuildTarget getJvmBuildTarget(GradleSourceSet sourceSet, JavaExtension javaExtension) {
        return new JvmBuildTargetEx(javaExtension.getJavaHome() == null ? "" : javaExtension.getJavaHome().toURI().toString(), javaExtension.getJavaVersion() == null ? "" : javaExtension.getJavaVersion(), sourceSet.getGradleVersion() == null ? "" : sourceSet.getGradleVersion(), javaExtension.getSourceCompatibility() == null ? "" : javaExtension.getSourceCompatibility(), javaExtension.getTargetCompatibility() == null ? "" : javaExtension.getTargetCompatibility());
    }

    private void setJvmBuildTarget(GradleSourceSet sourceSet, JavaExtension javaExtension, BuildTarget bt) {
        bt.setDataKind("jvm");
        bt.setData((Object)this.getJvmBuildTarget(sourceSet, javaExtension));
    }

    private ScalaBuildTarget getScalaBuildTarget(GradleSourceSet sourceSet, ScalaExtension scalaExtension, JavaExtension javaExtension) {
        JvmBuildTarget jvmBuildTarget = this.getJvmBuildTarget(sourceSet, javaExtension);
        List scalaJars = scalaExtension.getScalaJars().stream().map(file -> file.toURI().toString()).collect(Collectors.toList());
        ScalaBuildTarget scalaBuildTarget = new ScalaBuildTarget(scalaExtension.getScalaOrganization() == null ? "" : scalaExtension.getScalaOrganization(), scalaExtension.getScalaVersion() == null ? "" : scalaExtension.getScalaVersion(), scalaExtension.getScalaBinaryVersion() == null ? "" : scalaExtension.getScalaBinaryVersion(), ScalaPlatform.JVM, scalaJars);
        scalaBuildTarget.setJvmBuildTarget(jvmBuildTarget);
        return scalaBuildTarget;
    }

    private void setScalaBuildTarget(GradleSourceSet sourceSet, ScalaExtension scalaExtension, JavaExtension javaExtension, BuildTarget bt) {
        bt.setDataKind("scala");
        bt.setData((Object)this.getScalaBuildTarget(sourceSet, scalaExtension, javaExtension));
    }

    private void updateBuildTargetDependencies(Collection<GradleBuildTarget> gradleBuildTargets, Map<BuildTargetDependency, BuildTargetIdentifier> dependencyToBuildTargetId) {
        for (GradleBuildTarget gradleBuildTarget : gradleBuildTargets) {
            Set buildTargetDependencies = gradleBuildTarget.getSourceSet().getBuildTargetDependencies();
            if (buildTargetDependencies == null) continue;
            List btDependencies = buildTargetDependencies.stream().map(dependencyToBuildTargetId::get).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            gradleBuildTarget.getBuildTarget().setDependencies(btDependencies);
        }
    }
}

