/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.scripts.ScriptFileResolvedListener;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileUtil;

public class DefaultScriptFileResolver
implements ScriptFileResolver {
    private static final String[] EXTENSIONS = ScriptFileUtil.getValidExtensions();
    private final @Nullable ScriptFileResolvedListener scriptFileResolvedListener;

    public DefaultScriptFileResolver(@Nullable ScriptFileResolvedListener scriptFileResolvedListener) {
        this.scriptFileResolvedListener = scriptFileResolvedListener;
    }

    public DefaultScriptFileResolver() {
        this.scriptFileResolvedListener = null;
    }

    @Override
    public File resolveScriptFile(File dir, String basename) {
        for (String extension : EXTENSIONS) {
            File candidate = new File(dir, basename + extension);
            if (!this.isCandidateFile(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private boolean isCandidateFile(File candidate) {
        this.notifyListener(candidate);
        return candidate.isFile();
    }

    @Override
    public List<File> findScriptsIn(File dir) {
        File[] candidates = dir.listFiles();
        if (candidates == null || candidates.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> found = new ArrayList<File>(candidates.length);
        for (File candidate : candidates) {
            if (!candidate.isFile() || !this.hasScriptExtension(candidate)) continue;
            found.add(candidate);
        }
        return found;
    }

    private void notifyListener(File scriptFile) {
        if (this.scriptFileResolvedListener != null) {
            this.scriptFileResolvedListener.onScriptFileResolved(scriptFile);
        }
    }

    private boolean hasScriptExtension(File file) {
        for (String extension : EXTENSIONS) {
            if (!FileUtils.hasExtension(file, extension)) continue;
            return true;
        }
        return false;
    }
}

