# What's new in Visual Studio Code Java?

*February 2019*

Welcome to the February 2019 release of Extension Pack for Java. This document aims to recap the features, bug fixes around Java language support in between releases. Here are some of the key highlights:

- **[IntelliCode](#intellicode)** for faster coding assisted by AI
- **[Standalone Java Files](#standalone-java-files-supported)** better supported
- **[Performance](#performance)** improved
- **[Dependency Auto-Completion](#dependency-auto-completion-for-pom.xml-files)** for editing `pom.xml` files

The release notes are arranged in the following sections related to VS Code Java focus areas. Here are some further updates:

- **[Code Editing](#code-editing)**
- **[Source Code Management](#source-code-management)**
- **[Performance](#performance)**
- **[Maven](#maven)**
- **[Debugging](#debugging)**
- **[Testing](#testing)**

As always, please feel free to [tweet us your feedback](https://twitter.com/intent/tweet?via=code&hashtags=Java%2CHappyCoding) or [open issues](https://github.com/Microsoft/vscode-java-pack/issues).

## Code Editing

### IntelliCode

IntelliCode saves you time by putting what you’re most likely to use at the top of your completion list. IntelliCode recommendations are based on thousands of open source projects on GitHub each with over 100 stars. When combined with the context of your code, the completion list is tailored to promote common practices.

IntelliCode works well with popular Java libraries and frameworks like Java SE and Spring. It will help you whether you are doing monolithic web apps or modern microservices.

In the sample below, some of the completion lists have items marked with ★. These items are the recommendations provided by IntelliCode according to the current code context.

![IntelliCode](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.5.0/intellicode.gif)

**Note:** TypeScript/JavaScript, Python, C++, C# and XAML are also supported.

For more information, follow [this link](https://docs.microsoft.com/en-us/visualstudio/intellicode/intellicode-visual-studio-code).

### Bulk Generate Getters & Setters

More source actions were added to the language server. Now you can bulk generate getters and setters for all new member variables.

![Generate Getters & Setters](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/bulk.gen.getter.setter.gif)

## Source Code Management

### Standalone Java Files Supported

We improved the support for standalone Java files. If you want to work with Java files directly but don't bother to create a project, we've got you covered.

The solution is folder based, so all you need to do is open a folder, and all the Java files inside will be properly compiled. Then you are free to run or debug them.

![Standalone Java File Support](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/standalone.file.support.gif)

### Multiple Source Folder Supported

What if you have multiple sub-folders that have source code inside and want to go freestyle? We've got you covered too. Just add these folders to source path, then all the code inside will be correctly compiled.

![Multiple Source Folder Support](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/multiple.source.folder.gif)

### Hide Temporary Files

After opening a project folder, some extra files are generated inside the folder. These are the temporary files generated by Java Language Server, which relies on the existence of those files to work properly.

Now it's your choice to hide those files in VS Code. When opening a project folder, Java Language Server asks how you want handle those files. You can hide them globally or just within the current workspace, or leave them as-is.

![Hide Temporary Files](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/hide.temp.files.png)

## Performance

### Parallel Build

Thank to the improvement made from upstream JDT project, we can now enable parallel build in Java Language Server. By doing so, the time of loading a project can be reduced. The build process is per project. You will get the most performance gain when you have multiple child projects in your workspace.

To enable parallel build, open `settings.json` and set the option `java.maxConcurrentBuilds` to a numeric value. The recommended value is the number of CPU cores on your machine.

```json
{
    "java.maxConcurrentBuilds": 4 // on a 4 core machine
}
```

### Extension Load Time Reduced

The load time of Java extensions is reduced by adopting *webpack*. As you know, all VS Code extensions are written in JavaScript/TypeScript. Recently, we started to adopt webpack to generate the production packages, with code combined and minified. This dramatically reduced the extension load time.

Please update the extensions to the newest version, and you'll get this improvement automatically.

## Maven

### Dependency Auto-Completion for `pom.xml` files

Maven extension now provides code snippet to quickly add new dependencies to `pom.xml` files. You also get auto-completion when further completing the dependency info.

![Dependency Auto-Completion](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/pom-dependency-completion.gif)

### Maven Plugin Goals

Plugins and their goals are now listed in the explorer along with other Maven resources. You can execute the goals with a few clicks.

![Maven Plugin Goals](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/maven-plugin-goals.png)

### Flat View & Hierarchical View

Maven explorer now allows you to switch between flat view and hierarchical view, to your preference.

## Debugging

### Easy Launching for Multi-Main-Class Projects

When you have multiple main classes in your workspace, you can have a special launch configuration to launch whatever is in the active editor. This can be handy when you use hot keys. And here's the new configuration:

```json
{
    "type": "java",
    "name": "Debug (Launch) - Current File",
    "request": "launch",
    "mainClass": "${file}" // whatever main class in the active editor
}
```

![Multiple Main Class Easy Launch](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/multiple.main.entry.gif)

## Testing

### Test Configuration Reorganized

Test configurations are very useful in special test setups. Those configurations were originally stored in `launch.test.json`, which generated lots of confusions according to the user feedback.

We listened, and as a result, we **deprecated** `launch.test.json`, and replaced it with regular VS Code settings. Now, the test configurations stay in `settings.json`, which can be global or at the workspace level. And they look like this:

```json
"java.test.config": [
    {
        "name": "myTestConfiguration",
        "workingDirectory": "${workspaceFolder}",
        "args": [ "-c", "com.test" ],
        "vmargs": [ "-Xmx512M" ],
        "env": { "key": "value" },
    },
    {
        // Other configuration entry...
    }
]
```

For more details, visit [Test Runner Configurations](https://github.com/Microsoft/vscode-java-test/blob/main/runner-config.md).

### Navigate to Source from Test Report

You can now jump to the definition of a test case by clicking the link in test reports.

![Navigate to Source from Test Report](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.6.0/navigate.to.source.gif)

## Happy Coding!
