/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer.jpms;

import com.microsoft.gradle.bs.importer.jpms.JpmsArgType;
import com.microsoft.gradle.bs.importer.jpms.JpmsArgValue;
import com.microsoft.gradle.bs.importer.jpms.JpmsArguments;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.launching.JavaRuntime;

public class JpmsUtils {
    private static final String ATTRIBUTE_DELIMITER = ":";
    private static final String ARGUMENT_SEPARATOR = "=";

    public static JpmsArguments categorizeJpmsArguments(List<String> compilerArgs) {
        JpmsArguments jpmsArgs = new JpmsArguments();
        if (compilerArgs.isEmpty()) {
            return jpmsArgs;
        }
        ListIterator<String> iterator = compilerArgs.listIterator();
        while (iterator.hasNext()) {
            JpmsArgValue jpmsValue;
            JpmsArgType type;
            String arg = iterator.next();
            if (StringUtils.isBlank((CharSequence)arg)) continue;
            arg = arg.trim();
            String value = null;
            if (arg.indexOf(ARGUMENT_SEPARATOR) > -1) {
                value = arg.substring(arg.indexOf(ARGUMENT_SEPARATOR) + 1);
                arg = arg.substring(0, arg.indexOf(ARGUMENT_SEPARATOR));
            }
            if ((type = JpmsArgType.fromJavacArgumentName(arg)) == null) continue;
            if (value == null && iterator.hasNext()) {
                value = iterator.next();
            }
            if ((jpmsValue = type.parse(value)) == null) continue;
            jpmsArgs.addJpmsArgument(type, jpmsValue);
        }
        return jpmsArgs;
    }

    public static void appendJpmsAttributesToEntries(IJavaProject javaProject, Map<IPath, IClasspathEntry> classpathMap, JpmsArguments jpmsArgs) {
        for (Map.Entry<IPath, IClasspathEntry> mapEntry : classpathMap.entrySet()) {
            IClasspathEntry classpathEntry = mapEntry.getValue();
            if (classpathEntry.getEntryKind() == 1) {
                classpathEntry = JpmsUtils.updateJpmsAttributesForClasspathEntry(javaProject, classpathEntry, jpmsArgs, false);
                mapEntry.setValue(classpathEntry);
                continue;
            }
            if (classpathEntry.getEntryKind() != 5 || !mapEntry.getKey().toString().startsWith(JavaRuntime.JRE_CONTAINER)) continue;
            classpathEntry = JpmsUtils.updateJpmsAttributesForClasspathEntry(javaProject, classpathEntry, jpmsArgs, true);
            mapEntry.setValue(classpathEntry);
        }
    }

    public static IClasspathEntry updateJpmsAttributesForClasspathEntry(IJavaProject javaProject, IClasspathEntry entry, JpmsArguments jpmsArgs, boolean isJre) {
        LinkedList<IClasspathAttribute> jpmsAttributes = new LinkedList<IClasspathAttribute>();
        Set<String> availableModules = JpmsUtils.getJpmsModules(javaProject, entry, isJre);
        JpmsArgType[] jpmsArgTypeArray = JpmsArgType.values();
        int n = jpmsArgTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JpmsArgType type = jpmsArgTypeArray[n2];
            String aggregatedValue = JpmsUtils.getAggregatedValue(availableModules, jpmsArgs, type);
            if (StringUtils.isNotBlank((CharSequence)aggregatedValue)) {
                jpmsAttributes.add(JavaCore.newClasspathAttribute((String)type.getEclipseArgumentName(), (String)aggregatedValue));
            }
            ++n2;
        }
        if (jpmsAttributes.isEmpty()) {
            return entry;
        }
        jpmsAttributes.addAll(0, Arrays.asList(entry.getExtraAttributes()));
        if (isJre) {
            return JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])jpmsAttributes.toArray(new IClasspathAttribute[0]), (boolean)entry.isExported());
        }
        return JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])jpmsAttributes.toArray(new IClasspathAttribute[0]), (boolean)entry.isExported());
    }

    private static Set<String> getJpmsModules(IJavaProject javaProject, IClasspathEntry entry, boolean isJre) {
        IPackageFragmentRoot[] fragmentRoots;
        HashSet<String> result = new HashSet<String>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = javaProject.findUnfilteredPackageFragmentRoots(entry);
        int n = fragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleDescription module;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if ((isJre && root instanceof JrtPackageFragmentRoot || !isJre && root instanceof JarPackageFragmentRoot) && (module = root.getModuleDescription()) != null) {
                result.add(module.getElementName());
            }
            ++n2;
        }
        return result;
    }

    private static String getAggregatedValue(Set<String> availableModules, JpmsArguments jpmsArgs, JpmsArgType type) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, Set<String>>> it = jpmsArgs.getGroupedArgumentsByType(JpmsArgType.ADD_EXPORTS).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Set<String>> valueEntry = it.next();
            String moduleName = valueEntry.getKey();
            Set<String> values = valueEntry.getValue();
            if (!availableModules.contains(moduleName)) continue;
            sb.append(values.stream().collect(Collectors.joining(ATTRIBUTE_DELIMITER)));
            it.remove();
        }
        return sb.toString();
    }

    private JpmsUtils() {
    }
}

