/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsChannelFactory;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final WindowsPath file;
    private final boolean followLinks;

    private String join(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("'name' is null");
        }
        return string + ":" + string2;
    }

    private String join(WindowsPath windowsPath, String string) throws WindowsException {
        return this.join(windowsPath.getPathForWin32Calls(), string);
    }

    WindowsUserDefinedFileAttributeView(WindowsPath windowsPath, boolean bl) {
        this.file = windowsPath;
        this.followLinks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listUsingStreamEnumeration() throws IOException {
        ArrayList<String> arrayList;
        block7: {
            arrayList = new ArrayList<String>();
            try {
                WindowsNativeDispatcher.FirstStream firstStream = WindowsNativeDispatcher.FindFirstStream(this.file.getPathForWin32Calls());
                if (firstStream == null) break block7;
                long l = firstStream.handle();
                try {
                    String[] stringArray;
                    String string = firstStream.name();
                    if (!string.equals("::$DATA")) {
                        stringArray = string.split(":");
                        arrayList.add(stringArray[1]);
                    }
                    while ((string = WindowsNativeDispatcher.FindNextStream(l)) != null) {
                        stringArray = string.split(":");
                        arrayList.add(stringArray[1]);
                    }
                }
                finally {
                    WindowsNativeDispatcher.FindClose(l);
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(this.file);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listUsingBackupRead() throws IOException {
        long l = -1L;
        try {
            int n = 0x2000000;
            if (!this.followLinks && this.file.getFileSystem().supportsLinks()) {
                n |= 0x200000;
            }
            l = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), Integer.MIN_VALUE, 1, 3, n);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.file);
        }
        NativeBuffer nativeBuffer = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            nativeBuffer = NativeBuffers.getNativeBuffer(4096);
            long l2 = nativeBuffer.address();
            long l3 = 0L;
            try {
                while (true) {
                    WindowsNativeDispatcher.BackupResult backupResult = WindowsNativeDispatcher.BackupRead(l, l2, 20, false, l3);
                    l3 = backupResult.context();
                    if (backupResult.bytesTransferred() == 0) {
                        break;
                    }
                    int n = unsafe.getInt(l2 + 0L);
                    long l4 = unsafe.getLong(l2 + 8L);
                    int n2 = unsafe.getInt(l2 + 16L);
                    if (n2 > 0 && (backupResult = WindowsNativeDispatcher.BackupRead(l, l2, n2, false, l3)).bytesTransferred() != n2) {
                        break;
                    }
                    if (n == 4) {
                        char[] cArray = new char[n2 / 2];
                        unsafe.copyMemory(null, l2, cArray, Unsafe.ARRAY_CHAR_BASE_OFFSET, n2);
                        String[] stringArray = new String(cArray).split(":");
                        if (stringArray.length == 3) {
                            arrayList.add(stringArray[1]);
                        }
                    }
                    if (n == 9) {
                        throw new IOException("Spare blocks not handled");
                    }
                    if (l4 <= 0L) continue;
                    WindowsNativeDispatcher.BackupSeek(l, l4, l3);
                }
            }
            catch (WindowsException windowsException) {
                throw new IOException(windowsException.errorString());
            }
            finally {
                if (l3 != 0L) {
                    try {
                        WindowsNativeDispatcher.BackupRead(l, 0L, 0, true, l3);
                    }
                    catch (WindowsException windowsException) {}
                }
            }
        }
        finally {
            if (nativeBuffer != null) {
                nativeBuffer.release();
            }
            WindowsNativeDispatcher.CloseHandle(l);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        if (this.file.getFileSystem().supportsStreamEnumeration()) {
            return this.listUsingStreamEnumeration();
        }
        return this.listUsingBackupRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        FileChannel fileChannel = null;
        try {
            HashSet<OpenOption> hashSet = new HashSet<OpenOption>();
            hashSet.add(StandardOpenOption.READ);
            if (!this.followLinks) {
                hashSet.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            fileChannel = WindowsChannelFactory.newFileChannel(this.join(this.file, string), null, hashSet, 0L);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), string));
        }
        try {
            long l = fileChannel.size();
            if (l > Integer.MAX_VALUE) {
                throw new ArithmeticException("Stream too large");
            }
            int n = (int)l;
            return n;
        }
        finally {
            fileChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String string, ByteBuffer byteBuffer) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        FileChannel fileChannel = null;
        try {
            HashSet<OpenOption> hashSet = new HashSet<OpenOption>();
            hashSet.add(StandardOpenOption.READ);
            if (!this.followLinks) {
                hashSet.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            fileChannel = WindowsChannelFactory.newFileChannel(this.join(this.file, string), null, hashSet, 0L);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), string));
        }
        try {
            int n;
            if (fileChannel.size() > (long)byteBuffer.remaining()) {
                throw new IOException("Stream too large");
            }
            int n2 = 0;
            while (byteBuffer.hasRemaining() && (n = fileChannel.read(byteBuffer)) >= 0) {
                n2 += n;
            }
            n = n2;
            return n;
        }
        finally {
            fileChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String string, ByteBuffer byteBuffer) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        long l = -1L;
        try {
            int n = 0x2000000;
            if (!this.followLinks) {
                n |= 0x200000;
            }
            l = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), Integer.MIN_VALUE, 7, 3, n);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.file);
        }
        try {
            int n;
            HashSet<OpenOption> hashSet = new HashSet<OpenOption>();
            if (!this.followLinks) {
                hashSet.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            hashSet.add(StandardOpenOption.CREATE);
            hashSet.add(StandardOpenOption.WRITE);
            hashSet.add(StandardOpenOption.TRUNCATE_EXISTING);
            FileChannel fileChannel = null;
            try {
                fileChannel = WindowsChannelFactory.newFileChannel(this.join(this.file, string), null, hashSet, 0L);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), string));
            }
            try {
                int n2 = byteBuffer.remaining();
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
                n = n2;
            }
            catch (Throwable throwable) {
                fileChannel.close();
                throw throwable;
            }
            fileChannel.close();
            return n;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(l);
        }
    }

    @Override
    public void delete(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        String string2 = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        String string3 = this.join(string2, string);
        try {
            WindowsNativeDispatcher.DeleteFile(string3);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(string3);
        }
    }
}

