/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.util.Arrays;

public abstract class SNIServerName {
    private final int type;
    private final byte[] encoded;
    private static final char[] HEXES = "0123456789ABCDEF".toCharArray();

    protected SNIServerName(int n, byte[] byArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Server name type cannot be less than zero");
        }
        if (n > 255) {
            throw new IllegalArgumentException("Server name type cannot be greater than 255");
        }
        this.type = n;
        if (byArray == null) {
            throw new NullPointerException("Server name encoded value cannot be null");
        }
        this.encoded = (byte[])byArray.clone();
    }

    public final int getType() {
        return this.type;
    }

    public final byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SNIServerName sNIServerName = (SNIServerName)object;
        return this.type == sNIServerName.type && Arrays.equals(this.encoded, sNIServerName.encoded);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.type;
        n = 31 * n + Arrays.hashCode(this.encoded);
        return n;
    }

    public String toString() {
        if (this.type == 0) {
            return "type=host_name (0), value=" + SNIServerName.toHexString(this.encoded);
        }
        return "type=(" + this.type + "), value=" + SNIServerName.toHexString(this.encoded);
    }

    private static String toHexString(byte[] byArray) {
        if (byArray.length == 0) {
            return "(empty)";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3 - 1);
        boolean bl = true;
        for (byte by : byArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(':');
            }
            int n = by & 0xFF;
            stringBuilder.append(HEXES[n >>> 4]);
            stringBuilder.append(HEXES[n & 0xF]);
        }
        return stringBuilder.toString();
    }
}

