/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import sun.awt.AWTAccessor;
import sun.awt.AWTIcon32_security_icon_bw16_png;
import sun.awt.AWTIcon32_security_icon_bw24_png;
import sun.awt.AWTIcon32_security_icon_bw32_png;
import sun.awt.AWTIcon32_security_icon_bw48_png;
import sun.awt.AWTIcon32_security_icon_interim16_png;
import sun.awt.AWTIcon32_security_icon_interim24_png;
import sun.awt.AWTIcon32_security_icon_interim32_png;
import sun.awt.AWTIcon32_security_icon_interim48_png;
import sun.awt.AWTIcon32_security_icon_yellow16_png;
import sun.awt.AWTIcon32_security_icon_yellow24_png;
import sun.awt.AWTIcon32_security_icon_yellow32_png;
import sun.awt.AWTIcon32_security_icon_yellow48_png;
import sun.awt.AWTIcon64_security_icon_bw16_png;
import sun.awt.AWTIcon64_security_icon_bw24_png;
import sun.awt.AWTIcon64_security_icon_bw32_png;
import sun.awt.AWTIcon64_security_icon_bw48_png;
import sun.awt.AWTIcon64_security_icon_interim16_png;
import sun.awt.AWTIcon64_security_icon_interim24_png;
import sun.awt.AWTIcon64_security_icon_interim32_png;
import sun.awt.AWTIcon64_security_icon_interim48_png;
import sun.awt.AWTIcon64_security_icon_yellow16_png;
import sun.awt.AWTIcon64_security_icon_yellow24_png;
import sun.awt.AWTIcon64_security_icon_yellow32_png;
import sun.awt.AWTIcon64_security_icon_yellow48_png;
import sun.awt.IconInfo;
import sun.awt.SunToolkit;
import sun.awt.X11.InfoWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

class XWarningWindow
extends XWindow {
    private static final int SHOWING_DELAY = 330;
    private static final int HIDING_DELAY = 2000;
    private final Window ownerWindow;
    private WeakReference<XWindowPeer> ownerPeer;
    private long parentWindow;
    private static final String OWNER = "OWNER";
    private InfoWindow.Tooltip tooltip;
    private volatile int currentIcon = 0;
    private int currentSize = -1;
    private static IconInfo[][] icons;
    private final Runnable hidingTask = new Runnable(){

        @Override
        public void run() {
            XWarningWindow.this.xSetVisible(false);
        }
    };
    private final Runnable showingTask = new Runnable(){

        @Override
        public void run() {
            if (!XWarningWindow.this.isVisible()) {
                XWarningWindow.this.xSetVisible(true);
                XWarningWindow.this.updateIconSize();
                XWindowPeer xWindowPeer = (XWindowPeer)XWarningWindow.this.ownerPeer.get();
                if (xWindowPeer != null) {
                    xWindowPeer.repositionSecurityWarning();
                }
            }
            XWarningWindow.this.repaint();
            if (XWarningWindow.this.currentIcon > 0) {
                XWarningWindow.this.currentIcon--;
                XToolkit.schedule(XWarningWindow.this.showingTask, 330L);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IconInfo getSecurityIconInfo(int n, int n2) {
        Class<XWarningWindow> clazz = XWarningWindow.class;
        synchronized (XWarningWindow.class) {
            if (icons == null) {
                icons = new IconInfo[4][3];
                if (XlibWrapper.dataModel == 32) {
                    XWarningWindow.icons[0][0] = new IconInfo(AWTIcon32_security_icon_bw16_png.security_icon_bw16_png);
                    XWarningWindow.icons[0][1] = new IconInfo(AWTIcon32_security_icon_interim16_png.security_icon_interim16_png);
                    XWarningWindow.icons[0][2] = new IconInfo(AWTIcon32_security_icon_yellow16_png.security_icon_yellow16_png);
                    XWarningWindow.icons[1][0] = new IconInfo(AWTIcon32_security_icon_bw24_png.security_icon_bw24_png);
                    XWarningWindow.icons[1][1] = new IconInfo(AWTIcon32_security_icon_interim24_png.security_icon_interim24_png);
                    XWarningWindow.icons[1][2] = new IconInfo(AWTIcon32_security_icon_yellow24_png.security_icon_yellow24_png);
                    XWarningWindow.icons[2][0] = new IconInfo(AWTIcon32_security_icon_bw32_png.security_icon_bw32_png);
                    XWarningWindow.icons[2][1] = new IconInfo(AWTIcon32_security_icon_interim32_png.security_icon_interim32_png);
                    XWarningWindow.icons[2][2] = new IconInfo(AWTIcon32_security_icon_yellow32_png.security_icon_yellow32_png);
                    XWarningWindow.icons[3][0] = new IconInfo(AWTIcon32_security_icon_bw48_png.security_icon_bw48_png);
                    XWarningWindow.icons[3][1] = new IconInfo(AWTIcon32_security_icon_interim48_png.security_icon_interim48_png);
                    XWarningWindow.icons[3][2] = new IconInfo(AWTIcon32_security_icon_yellow48_png.security_icon_yellow48_png);
                } else {
                    XWarningWindow.icons[0][0] = new IconInfo(AWTIcon64_security_icon_bw16_png.security_icon_bw16_png);
                    XWarningWindow.icons[0][1] = new IconInfo(AWTIcon64_security_icon_interim16_png.security_icon_interim16_png);
                    XWarningWindow.icons[0][2] = new IconInfo(AWTIcon64_security_icon_yellow16_png.security_icon_yellow16_png);
                    XWarningWindow.icons[1][0] = new IconInfo(AWTIcon64_security_icon_bw24_png.security_icon_bw24_png);
                    XWarningWindow.icons[1][1] = new IconInfo(AWTIcon64_security_icon_interim24_png.security_icon_interim24_png);
                    XWarningWindow.icons[1][2] = new IconInfo(AWTIcon64_security_icon_yellow24_png.security_icon_yellow24_png);
                    XWarningWindow.icons[2][0] = new IconInfo(AWTIcon64_security_icon_bw32_png.security_icon_bw32_png);
                    XWarningWindow.icons[2][1] = new IconInfo(AWTIcon64_security_icon_interim32_png.security_icon_interim32_png);
                    XWarningWindow.icons[2][2] = new IconInfo(AWTIcon64_security_icon_yellow32_png.security_icon_yellow32_png);
                    XWarningWindow.icons[3][0] = new IconInfo(AWTIcon64_security_icon_bw48_png.security_icon_bw48_png);
                    XWarningWindow.icons[3][1] = new IconInfo(AWTIcon64_security_icon_interim48_png.security_icon_interim48_png);
                    XWarningWindow.icons[3][2] = new IconInfo(AWTIcon64_security_icon_yellow48_png.security_icon_yellow48_png);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int n3 = n % icons.length;
            return icons[n3][n2 % icons[n3].length];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIconSize() {
        Object object;
        int n = -1;
        if (this.ownerWindow != null) {
            object = this.ownerWindow.getInsets();
            int n2 = Math.max(((Insets)object).top, Math.max(((Insets)object).bottom, Math.max(((Insets)object).left, ((Insets)object).right)));
            n = n2 < 24 ? 0 : (n2 < 32 ? 1 : (n2 < 48 ? 2 : 3));
        }
        if (n == -1) {
            n = 0;
        }
        XToolkit.awtLock();
        try {
            if (n != this.currentSize) {
                this.currentSize = n;
                object = XWarningWindow.getSecurityIconInfo(this.currentSize, 0);
                XlibWrapper.SetBitmapShape(XToolkit.getDisplay(), this.getWindow(), ((IconInfo)object).getWidth(), ((IconInfo)object).getHeight(), ((IconInfo)object).getIntData());
                AWTAccessor.getWindowAccessor().setSecurityWarningSize(this.ownerWindow, ((IconInfo)object).getWidth(), ((IconInfo)object).getHeight());
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private IconInfo getSecurityIconInfo() {
        this.updateIconSize();
        return XWarningWindow.getSecurityIconInfo(this.currentSize, this.currentIcon);
    }

    XWarningWindow(Window window, long l, XWindowPeer xWindowPeer) {
        super(new XCreateWindowParams(new Object[]{"target", window, OWNER, l}));
        this.ownerWindow = window;
        this.parentWindow = l;
        this.tooltip = new InfoWindow.Tooltip(null, this.getTarget(), new InfoWindow.Tooltip.LiveArguments(){

            @Override
            public boolean isDisposed() {
                return XWarningWindow.this.isDisposed();
            }

            @Override
            public Rectangle getBounds() {
                return XWarningWindow.this.getBounds();
            }

            @Override
            public String getTooltipString() {
                return XWarningWindow.this.ownerWindow.getWarningString();
            }
        });
        this.ownerPeer = new WeakReference<XWindowPeer>(xWindowPeer);
    }

    private void requestNoTaskbar() {
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        if (xNETProtocol != null) {
            xNETProtocol.requestState(this, xNETProtocol.XA_NET_WM_STATE_SKIP_TASKBAR, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        XToolkit.awtLock();
        try {
            XWM.setMotifDecor(this, false, 0, 0);
            XWM.setOLDecor(this, false, 0);
            long l = (Long)xCreateWindowParams.get(OWNER);
            XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), this.getWindow(), l);
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(xWMHints.get_flags() | 1L | 2L);
            xWMHints.set_input(false);
            xWMHints.set_initial_state(1);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
            this.initWMProtocols();
            this.requestNoTaskbar();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void reposition(int n, int n2, int n3, int n4) {
        Point2D point2D = AWTAccessor.getWindowAccessor().calculateSecurityWarningPosition(this.ownerWindow, n, n2, n3, n4);
        this.reshape((int)point2D.getX(), (int)point2D.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected String getWMName() {
        return "Warning window";
    }

    @Override
    public Graphics getGraphics() {
        if (this.surfaceData == null || this.ownerWindow == null) {
            return null;
        }
        return this.getGraphics(this.surfaceData, this.getColor(), this.getBackground(), this.getFont());
    }

    void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(this.getSecurityIconInfo().getImage(), 0, 0, null);
    }

    String getWarningString() {
        return this.ownerWindow.getWarningString();
    }

    @Override
    int getWidth() {
        return this.getSecurityIconInfo().getWidth();
    }

    @Override
    int getHeight() {
        return this.getSecurityIconInfo().getHeight();
    }

    Color getBackground() {
        return SystemColor.window;
    }

    Color getColor() {
        return Color.black;
    }

    Font getFont() {
        return this.ownerWindow.getFont();
    }

    @Override
    public void repaint() {
        Rectangle rectangle = this.getBounds();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paint(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    @Override
    public void handleExposeEvent(XEvent xEvent) {
        super.handleExposeEvent(xEvent);
        XExposeEvent xExposeEvent = xEvent.get_xexpose();
        final int n = xExposeEvent.get_x();
        final int n2 = xExposeEvent.get_y();
        final int n3 = xExposeEvent.get_width();
        final int n4 = xExposeEvent.get_height();
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                Graphics graphics = XWarningWindow.this.getGraphics();
                if (graphics != null) {
                    try {
                        XWarningWindow.this.paint(graphics, n, n2, n3, n4);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            }
        });
    }

    @Override
    protected boolean isEventDisabled(XEvent xEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withdraw() {
        XEvent xEvent = new XEvent();
        try {
            long l;
            XToolkit.awtLock();
            try {
                l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            }
            finally {
                XToolkit.awtUnlock();
            }
            xEvent.set_type(18);
            XUnmapEvent xUnmapEvent = xEvent.get_xunmap();
            xUnmapEvent.set_event(l);
            xUnmapEvent.set_window(this.getWindow());
            xUnmapEvent.set_from_configure(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), l, false, 0x180000L, xEvent.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            xEvent.dispose();
        }
    }

    @Override
    protected void stateChanged(long l, int n, int n2) {
        if (n2 == 3) {
            super.xSetVisible(false);
            this.withdraw();
        }
    }

    @Override
    protected void setMouseAbove(boolean bl) {
        super.setMouseAbove(bl);
        XWindowPeer xWindowPeer = (XWindowPeer)this.ownerPeer.get();
        if (xWindowPeer != null) {
            xWindowPeer.updateSecurityWarningVisibility();
        }
    }

    @Override
    protected void enterNotify(long l) {
        super.enterNotify(l);
        if (l == this.getWindow()) {
            this.tooltip.enter();
        }
    }

    @Override
    protected void leaveNotify(long l) {
        super.leaveNotify(l);
        if (l == this.getWindow()) {
            this.tooltip.exit();
        }
    }

    @Override
    public void xSetVisible(boolean bl) {
        super.xSetVisible(bl);
        this.requestNoTaskbar();
    }

    public void setSecurityWarningVisible(boolean bl, boolean bl2) {
        if (bl) {
            XToolkit.remove(this.hidingTask);
            XToolkit.remove(this.showingTask);
            this.currentIcon = this.isVisible() ? 0 : 3;
            if (bl2) {
                XToolkit.schedule(this.showingTask, 1L);
            } else {
                this.showingTask.run();
            }
        } else {
            XToolkit.remove(this.showingTask);
            XToolkit.remove(this.hidingTask);
            if (!this.isVisible()) {
                return;
            }
            if (bl2) {
                XToolkit.schedule(this.hidingTask, 2000L);
            } else {
                this.hidingTask.run();
            }
        }
    }
}

