/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapName;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.ReferralEnumeration;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;

abstract class AbstractLdapNamingEnumeration<T extends NameClassPair>
implements NamingEnumeration<T>,
ReferralEnumeration<T> {
    protected Name listArg;
    private boolean cleaned = false;
    private LdapResult res;
    private LdapClient enumClnt;
    private Continuation cont;
    private Vector<LdapEntry> entries = null;
    private int limit = 0;
    private int posn = 0;
    protected LdapCtx homeCtx;
    private LdapReferralException refEx = null;
    private NamingException errEx = null;
    private boolean more = true;
    private boolean hasMoreCalled = false;

    AbstractLdapNamingEnumeration(LdapCtx ldapCtx, LdapResult ldapResult, Name name, Continuation continuation) throws NamingException {
        if (ldapResult.status != 0 && ldapResult.status != 4 && ldapResult.status != 3 && ldapResult.status != 11 && ldapResult.status != 10 && ldapResult.status != 9) {
            NamingException namingException = new NamingException(LdapClient.getErrorMessage(ldapResult.status, ldapResult.errorMessage));
            throw continuation.fillInException(namingException);
        }
        this.res = ldapResult;
        this.entries = ldapResult.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.listArg = name;
        this.cont = continuation;
        if (ldapResult.refEx != null) {
            this.refEx = ldapResult.refEx;
        }
        this.homeCtx = ldapCtx;
        ldapCtx.incEnumCount();
        this.enumClnt = ldapCtx.clnt;
    }

    @Override
    public final T nextElement() {
        try {
            return (T)this.next();
        }
        catch (NamingException namingException) {
            this.cleanup();
            return null;
        }
    }

    @Override
    public final boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException namingException) {
            this.cleanup();
            return false;
        }
    }

    private void getNextBatch() throws NamingException {
        this.res = this.homeCtx.getSearchReply(this.enumClnt, this.res);
        if (this.res == null) {
            this.posn = 0;
            this.limit = 0;
            return;
        }
        this.entries = this.res.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.posn = 0;
        if (this.res.status != 0 || this.res.status == 0 && this.res.referrals != null) {
            try {
                this.homeCtx.processReturnCode(this.res, this.listArg);
            }
            catch (LimitExceededException | PartialResultException namingException) {
                this.setNamingException(namingException);
            }
        }
        if (this.res.refEx != null) {
            this.refEx = this.refEx == null ? this.res.refEx : this.refEx.appendUnprocessedReferrals(this.res.refEx);
            this.res.refEx = null;
        }
        if (this.res.resControls != null) {
            this.homeCtx.respCtls = this.res.resControls;
        }
    }

    @Override
    public final boolean hasMore() throws NamingException {
        if (this.hasMoreCalled) {
            return this.more;
        }
        this.hasMoreCalled = true;
        if (!this.more) {
            return false;
        }
        this.more = this.hasMoreImpl();
        return this.more;
    }

    @Override
    public final T next() throws NamingException {
        if (!this.hasMoreCalled) {
            this.hasMore();
        }
        this.hasMoreCalled = false;
        return this.nextImpl();
    }

    private boolean hasMoreImpl() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn < this.limit) {
            return true;
        }
        try {
            return this.hasMoreReferrals();
        }
        catch (LdapReferralException | LimitExceededException | PartialResultException namingException) {
            this.cleanup();
            throw namingException;
        }
        catch (NamingException namingException) {
            this.cleanup();
            PartialResultException partialResultException = new PartialResultException();
            partialResultException.setRootCause(namingException);
            throw partialResultException;
        }
    }

    private T nextImpl() throws NamingException {
        try {
            return this.nextAux();
        }
        catch (NamingException namingException) {
            this.cleanup();
            throw this.cont.fillInException(namingException);
        }
    }

    private T nextAux() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn >= this.limit) {
            this.cleanup();
            throw new NoSuchElementException("invalid enumeration handle");
        }
        LdapEntry ldapEntry = this.entries.elementAt(this.posn++);
        return this.createItem(ldapEntry.DN, ldapEntry.attributes, ldapEntry.respCtls);
    }

    protected final String getAtom(String string) {
        try {
            LdapName ldapName = new LdapName(string);
            return ldapName.get(ldapName.size() - 1);
        }
        catch (NamingException namingException) {
            return string;
        }
    }

    protected abstract T createItem(String var1, Attributes var2, Vector<Control> var3) throws NamingException;

    @Override
    public void appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        this.refEx = this.refEx != null ? this.refEx.appendUnprocessedReferrals(ldapReferralException) : ldapReferralException.appendUnprocessedReferrals(this.refEx);
    }

    final void setNamingException(NamingException namingException) {
        this.errEx = namingException;
    }

    protected abstract AbstractLdapNamingEnumeration<? extends NameClassPair> getReferredResults(LdapReferralContext var1) throws NamingException;

    protected final boolean hasMoreReferrals() throws NamingException {
        if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
            if (this.homeCtx.handleReferrals == 2) {
                throw (NamingException)this.refEx.fillInStackTrace();
            }
            while (true) {
                LdapReferralContext ldapReferralContext = (LdapReferralContext)this.refEx.getReferralContext(this.homeCtx.envprops, this.homeCtx.reqCtls);
                try {
                    this.update(this.getReferredResults(ldapReferralContext));
                }
                catch (LdapReferralException ldapReferralException) {
                    if (this.errEx == null) {
                        this.errEx = ldapReferralException.getNamingException();
                    }
                    this.refEx = ldapReferralException;
                    continue;
                }
                finally {
                    ldapReferralContext.close();
                    continue;
                }
                break;
            }
            return this.hasMoreImpl();
        }
        this.cleanup();
        if (this.errEx != null) {
            throw this.errEx;
        }
        return false;
    }

    protected void update(AbstractLdapNamingEnumeration<? extends NameClassPair> abstractLdapNamingEnumeration) {
        this.homeCtx.decEnumCount();
        this.homeCtx = abstractLdapNamingEnumeration.homeCtx;
        this.enumClnt = abstractLdapNamingEnumeration.enumClnt;
        abstractLdapNamingEnumeration.homeCtx = null;
        this.posn = abstractLdapNamingEnumeration.posn;
        this.limit = abstractLdapNamingEnumeration.limit;
        this.res = abstractLdapNamingEnumeration.res;
        this.entries = abstractLdapNamingEnumeration.entries;
        this.refEx = abstractLdapNamingEnumeration.refEx;
        this.listArg = abstractLdapNamingEnumeration.listArg;
    }

    protected final void finalize() {
        this.cleanup();
    }

    protected final void cleanup() {
        if (this.cleaned) {
            return;
        }
        if (this.enumClnt != null) {
            this.enumClnt.clearSearchReply(this.res, this.homeCtx.reqCtls);
        }
        this.enumClnt = null;
        this.cleaned = true;
        if (this.homeCtx != null) {
            this.homeCtx.decEnumCount();
            this.homeCtx = null;
        }
    }

    @Override
    public final void close() {
        this.cleanup();
    }
}

