/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;
import sun.net.NetProperties;
import sun.util.logging.PlatformLogger;

public class HttpCapture {
    private File file = null;
    private boolean incoming = true;
    private BufferedWriter out = null;
    private static boolean initialized = false;
    private static volatile ArrayList<Pattern> patterns = null;
    private static volatile ArrayList<String> capFiles = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void init() {
        initialized = true;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return NetProperties.get("sun.net.http.captureRules");
            }
        });
        if (string != null && !string.isEmpty()) {
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String[] stringArray;
                    if (!(string2 = string2.trim()).startsWith("#") && (stringArray = string2.split(",")).length == 2) {
                        if (patterns == null) {
                            patterns = new ArrayList();
                            capFiles = new ArrayList();
                        }
                        patterns.add(Pattern.compile(stringArray[0].trim()));
                        capFiles.add(stringArray[1].trim());
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static synchronized boolean isInitialized() {
        return initialized;
    }

    private HttpCapture(File file, URL uRL) {
        this.file = file;
        try {
            this.out = new BufferedWriter(new FileWriter(this.file, true));
            this.out.write("URL: " + uRL + "\n");
        }
        catch (IOException iOException) {
            PlatformLogger.getLogger(HttpCapture.class.getName()).severe(null, iOException);
        }
    }

    public synchronized void sent(int n) throws IOException {
        if (this.incoming) {
            this.out.write("\n------>\n");
            this.incoming = false;
            this.out.flush();
        }
        this.out.write(n);
    }

    public synchronized void received(int n) throws IOException {
        if (!this.incoming) {
            this.out.write("\n<------\n");
            this.incoming = true;
            this.out.flush();
        }
        this.out.write(n);
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public static HttpCapture getCapture(URL uRL) {
        if (!HttpCapture.isInitialized()) {
            HttpCapture.init();
        }
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        String string = uRL.toString();
        for (int i = 0; i < patterns.size(); ++i) {
            File file;
            Pattern pattern = patterns.get(i);
            if (!pattern.matcher(string).find()) continue;
            String string2 = capFiles.get(i);
            if (string2.indexOf("%d") >= 0) {
                String string3;
                Random random = new Random();
                while ((file = new File(string3 = string2.replace("%d", Integer.toString(random.nextInt())))).exists()) {
                }
            } else {
                file = new File(string2);
            }
            return new HttpCapture(file, uRL);
        }
        return null;
    }
}

