/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream;

import java.util.NoSuchElementException;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class EventFilterSupport
extends EventReaderDelegate {
    EventFilter fEventFilter;

    public EventFilterSupport(XMLEventReader eventReader, EventFilter eventFilter) {
        this.setParent(eventReader);
        this.fEventFilter = eventFilter;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException ex) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.peek() != null;
        }
        catch (XMLStreamException ex) {
            return false;
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (super.hasNext()) {
            XMLEvent event = super.nextEvent();
            if (this.fEventFilter.accept(event)) {
                return event;
            }
            return this.nextEvent();
        }
        throw new NoSuchElementException();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        if (super.hasNext()) {
            XMLEvent event = super.nextTag();
            if (this.fEventFilter.accept(event)) {
                return event;
            }
            return this.nextTag();
        }
        throw new NoSuchElementException();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent event;
        while ((event = super.peek()) != null) {
            if (this.fEventFilter.accept(event)) {
                return event;
            }
            super.next();
        }
        return null;
    }
}

