/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.security.AccessController;
import java.util.Base64;
import java.util.HashMap;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;
import sun.security.action.GetPropertyAction;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private final HttpCallerInfo hci;
    static HashMap<String, Boolean> supported = null;
    static ThreadLocal<HashMap<String, Negotiator>> cache = null;
    private static final boolean cacheSPNEGO;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(HttpCallerInfo httpCallerInfo) {
        super(Authenticator.RequestorType.PROXY == httpCallerInfo.authType ? (char)'p' : 's', httpCallerInfo.scheme.equalsIgnoreCase("Negotiate") ? AuthScheme.NEGOTIATE : AuthScheme.KERBEROS, httpCallerInfo.url, "");
        this.hci = httpCallerInfo;
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static synchronized boolean isSupported(HttpCallerInfo httpCallerInfo) {
        if (supported == null) {
            supported = new HashMap();
        }
        String string = httpCallerInfo.host;
        if (supported.containsKey(string = string.toLowerCase())) {
            return supported.get(string);
        }
        Negotiator negotiator = Negotiator.getNegotiator(httpCallerInfo);
        if (negotiator != null) {
            supported.put(string, true);
            if (cache == null) {
                cache = new ThreadLocal<HashMap<String, Negotiator>>(){

                    @Override
                    protected HashMap<String, Negotiator> initialValue() {
                        return new HashMap<String, Negotiator>();
                    }
                };
            }
            cache.get().put(string, negotiator);
            return true;
        }
        supported.put(string, false);
        return false;
    }

    private static synchronized HashMap<String, Negotiator> getCache() {
        if (cache == null) {
            return null;
        }
        return cache.get();
    }

    @Override
    protected boolean useAuthCache() {
        return super.useAuthCache() && cacheSPNEGO;
    }

    @Override
    public String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String string) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            byte[] byArray = null;
            String[] stringArray = string.split("\\s+");
            if (stringArray.length > 1) {
                byArray = Base64.getDecoder().decode(stringArray[1]);
            }
            String string2 = this.hci.scheme + " " + Base64.getEncoder().encodeToString(byArray == null ? this.firstToken() : this.nextToken(byArray));
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private byte[] firstToken() throws IOException {
        this.negotiator = null;
        HashMap<String, Negotiator> hashMap = NegotiateAuthentication.getCache();
        if (hashMap != null) {
            this.negotiator = hashMap.get(this.getHost());
            if (this.negotiator != null) {
                hashMap.remove(this.getHost());
            }
        }
        if (this.negotiator == null) {
            this.negotiator = Negotiator.getNegotiator(this.hci);
            if (this.negotiator == null) {
                IOException iOException = new IOException("Cannot initialize Negotiator");
                throw iOException;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] byArray) throws IOException {
        return this.negotiator.nextToken(byArray);
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.spnego.cache", "true"));
        cacheSPNEGO = Boolean.parseBoolean(string);
    }
}

