/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaImageFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;
import sun.awt.image.MultiResolutionCachedImage;
import sun.lwawt.macosx.CImage;
import sun.misc.Launcher;
import sun.reflect.misc.ReflectUtil;
import sun.security.action.GetPropertyAction;
import sun.swing.SwingUtilities2;

final class AquaUtils {
    private static final String ANIMATIONS_PROPERTY = "swing.enableAnimations";
    private static final RecyclableSingleton<CImage.Creator> cImageCreator = new RecyclableSingleton<CImage.Creator>(){

        @Override
        protected CImage.Creator getInstance() {
            return AquaUtils.getCImageCreatorInternal();
        }
    };
    private static final RecyclableSingleton<Boolean> enableAnimations = new RecyclableSingleton<Boolean>(){

        @Override
        protected Boolean getInstance() {
            String string = AccessController.doPrivileged(new GetPropertyAction(AquaUtils.ANIMATIONS_PROPERTY));
            return !"false".equals(string);
        }
    };
    private static final int MENU_BLINK_DELAY = 50;
    private static final RecyclableSingleton<Method> getJComponentGetFlagMethod = new RecyclableSingleton<Method>(){

        @Override
        protected Method getInstance() {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method method = JComponent.class.getDeclaredMethod("getFlag", Integer.TYPE);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            });
        }
    };
    private static final Integer OPAQUE_SET_FLAG = 24;

    private AquaUtils() {
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static void enforceComponentOrientation(Component component, ComponentOrientation componentOrientation) {
        component.setComponentOrientation(componentOrientation);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                AquaUtils.enforceComponentOrientation(component2, componentOrientation);
            }
        }
    }

    private static CImage.Creator getCImageCreatorInternal() {
        return AccessController.doPrivileged(new PrivilegedAction<CImage.Creator>(){

            @Override
            public CImage.Creator run() {
                try {
                    Method method = CImage.class.getDeclaredMethod("getCreator", new Class[0]);
                    method.setAccessible(true);
                    return (CImage.Creator)method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static CImage.Creator getCImageCreator() {
        return cImageCreator.get();
    }

    static Image generateSelectedDarkImage(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new IconImageFilter(){

            @Override
            int getGreyFor(int n) {
                return n * 75 / 100;
            }
        });
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    static Image generateDisabledImage(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new IconImageFilter(){

            @Override
            int getGreyFor(int n) {
                return 255 - (255 - n) * 65 / 100;
            }
        });
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    static Image generateLightenedImage(Image image2, int n) {
        GrayFilter grayFilter = new GrayFilter(true, n);
        return image2 instanceof MultiResolutionCachedImage ? ((MultiResolutionCachedImage)image2).map(image -> AquaUtils.generateLightenedImage(image, grayFilter)) : AquaUtils.generateLightenedImage(image2, grayFilter);
    }

    static Image generateLightenedImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private static boolean animationsEnabled() {
        return enableAnimations.get();
    }

    static void blinkMenu(Selectable selectable) {
        if (!AquaUtils.animationsEnabled()) {
            return;
        }
        try {
            selectable.paintSelected(false);
            Thread.sleep(50L);
            selectable.paintSelected(true);
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void paintDropShadowText(Graphics graphics, JComponent jComponent, Font font, FontMetrics fontMetrics, int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        graphics.setFont(font);
        graphics.setColor(color2);
        SwingUtilities2.drawString(jComponent, graphics, string, n + n3, n2 + n4 + fontMetrics.getAscent());
        graphics.setColor(color);
        SwingUtilities2.drawString(jComponent, graphics, string, n, n2 + fontMetrics.getAscent());
    }

    static boolean shouldUseOpaqueButtons() {
        ClassLoader classLoader = Launcher.getLauncher().getClassLoader();
        return AquaUtils.classExists(classLoader, "com.installshield.wizard.platform.macosx.MacOSXUtils");
    }

    private static boolean classExists(ClassLoader classLoader, String string) {
        try {
            return Class.forName(string, false, classLoader) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        Method method = getJComponentGetFlagMethod.get();
        if (method == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(method.invoke(jComponent, OPAQUE_SET_FLAG));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isWindowTextured(Component component) {
        if (!(component instanceof JComponent)) {
            return false;
        }
        JRootPane jRootPane = ((JComponent)component).getRootPane();
        if (jRootPane == null) {
            return false;
        }
        Object object = jRootPane.getClientProperty("apple.awt.brushMetalLook");
        if (object != null) {
            return Boolean.parseBoolean(object.toString());
        }
        object = jRootPane.getClientProperty("Window.style");
        return object != null && "textured".equals(object);
    }

    private static Color resetAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }

    static void fillRect(Graphics graphics, Component component) {
        AquaUtils.fillRect(graphics, component, component.getBackground(), 0, 0, component.getWidth(), component.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillRect(Graphics graphics, Component component, Color color, int n, int n2, int n3, int n4) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            if (color instanceof UIResource && AquaUtils.isWindowTextured(component) && color.equals(SystemColor.window)) {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setColor(AquaUtils.resetAlpha(color));
            } else {
                graphics2D.setColor(color);
            }
            graphics2D.fillRect(n, n2, n3, n4);
        }
        finally {
            graphics2D.dispose();
        }
    }

    static class SlicedShadowBorder
    extends ShadowBorder {
        private final AquaImageFactory.SlicedImageControl slices;

        SlicedShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            super(painter, painter2, n, n2, f, f2, n3);
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 3);
            super.paintBorder(null, bufferedImage.getGraphics(), 0, 0, n4, n5);
            this.slices = new AquaImageFactory.SlicedImageControl(bufferedImage, n6, n7, n8, n9, false);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.slices.paint(graphics, n, n2, n3, n4);
        }
    }

    static class ShadowBorder
    implements Border {
        private final Painter prePainter;
        private final Painter postPainter;
        private final int offsetX;
        private final int offsetY;
        private final float distance;
        private final int blur;
        private final Insets insets;
        private final ConvolveOp blurOp;

        ShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3) {
            this.prePainter = painter;
            this.postPainter = painter2;
            this.offsetX = n;
            this.offsetY = n2;
            this.distance = f;
            this.blur = n3;
            int n4 = n3 / 2;
            this.insets = new Insets(n4 - n2, n4 - n, n4 + n2, n4 + n);
            float f3 = f2 / (float)(n3 * n3);
            float[] fArray = new float[n3 * n3];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f3;
            }
            this.blurOp = new ConvolveOp(new Kernel(n3, n3, fArray));
        }

        @Override
        public final boolean isBorderOpaque() {
            return false;
        }

        @Override
        public final Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BufferedImage bufferedImage = new BufferedImage(n3 + this.blur * 2, n4 + this.blur * 2, 3);
            this.paintToImage(bufferedImage, n, n2, n3, n4);
            graphics.drawImage(bufferedImage, -this.blur, -this.blur, null);
        }

        private void paintToImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, n3 + this.blur * 2, n4 + this.blur * 2);
            int n5 = (int)((float)(n + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
            int n6 = (int)((float)(n2 + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
            int n7 = (int)((float)n3 - (float)(this.insets.left + this.insets.right) * this.distance);
            int n8 = (int)((float)n4 - (float)(this.insets.top + this.insets.bottom) * this.distance);
            graphics2D.setComposite(AlphaComposite.DstAtop);
            if (this.prePainter != null) {
                this.prePainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.DstAtop);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.drawImage(bufferedImage, this.blurOp, 0, 0);
            if (this.postPainter != null) {
                this.postPainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
        }
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }

    static interface JComponentPainter {
        public void paint(JComponent var1, Graphics var2, int var3, int var4, int var5, int var6);
    }

    static interface Selectable {
        public void paintSelected(boolean var1);
    }

    static abstract class LazyKeyedSingleton<K, V> {
        private Map<K, V> refs;

        LazyKeyedSingleton() {
        }

        V get(K k) {
            V v;
            if (this.refs == null) {
                this.refs = new HashMap();
            }
            if ((v = this.refs.get(k)) != null) {
                return v;
            }
            V v2 = this.getInstance(k);
            this.refs.put(k, v2);
            return v2;
        }

        protected abstract V getInstance(K var1);
    }

    static class RecyclableSingletonFromDefaultConstructor<T>
    extends RecyclableSingleton<T> {
        private final Class<T> clazz;

        RecyclableSingletonFromDefaultConstructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        T getInstance() {
            try {
                ReflectUtil.checkPackageAccess(this.clazz);
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                return null;
            }
        }
    }

    static abstract class RecyclableSingleton<T> {
        RecyclableSingleton() {
        }

        final T get() {
            return (T)AppContext.getSoftReferenceValue(this, () -> this.getInstance());
        }

        void reset() {
            AppContext.getAppContext().remove(this);
        }

        abstract T getInstance();
    }

    static abstract class RecyclableObject<T> {
        private SoftReference<T> objectRef;

        RecyclableObject() {
        }

        T get() {
            T t;
            if (this.objectRef != null && (t = this.objectRef.get()) != null) {
                return t;
            }
            t = this.create();
            this.objectRef = new SoftReference<T>(t);
            return t;
        }

        protected abstract T create();
    }

    private static abstract class IconImageFilter
    extends RGBImageFilter {
        IconImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            int n7 = this.getGreyFor((int)((0.3 * (double)n4 + 0.59 * (double)n5 + 0.11 * (double)n6) / 3.0));
            return n3 & 0xFF000000 | IconImageFilter.grayTransform(n4, n7) << 16 | IconImageFilter.grayTransform(n5, n7) << 8 | IconImageFilter.grayTransform(n6, n7) << 0;
        }

        private static int grayTransform(int n, int n2) {
            int n3 = n - n2;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            return n3;
        }

        abstract int getGreyFor(int var1);
    }
}

