/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.stream.AbstractSpinedBuffer;
import java.util.stream.Tripwire;

class SpinedBuffer<E>
extends AbstractSpinedBuffer
implements Consumer<E>,
Iterable<E> {
    protected E[] curChunk;
    protected E[][] spine;
    private static final int SPLITERATOR_CHARACTERISTICS = 16464;

    SpinedBuffer(int n) {
        super(n);
        this.curChunk = new Object[1 << this.initialChunkPower];
    }

    SpinedBuffer() {
        this.curChunk = new Object[1 << this.initialChunkPower];
    }

    protected long capacity() {
        return this.spineIndex == 0 ? (long)this.curChunk.length : this.priorElementCount[this.spineIndex] + (long)this.spine[this.spineIndex].length;
    }

    private void inflateSpine() {
        if (this.spine == null) {
            this.spine = new Object[8][];
            this.priorElementCount = new long[8];
            this.spine[0] = this.curChunk;
        }
    }

    protected final void ensureCapacity(long l) {
        long l2 = this.capacity();
        if (l > l2) {
            this.inflateSpine();
            int n = this.spineIndex + 1;
            while (l > l2) {
                int n2;
                if (n >= this.spine.length) {
                    n2 = this.spine.length * 2;
                    this.spine = (Object[][])Arrays.copyOf(this.spine, n2);
                    this.priorElementCount = Arrays.copyOf(this.priorElementCount, n2);
                }
                n2 = this.chunkSize(n);
                this.spine[n] = new Object[n2];
                this.priorElementCount[n] = this.priorElementCount[n - 1] + (long)this.spine[n - 1].length;
                l2 += (long)n2;
                ++n;
            }
        }
    }

    protected void increaseCapacity() {
        this.ensureCapacity(this.capacity() + 1L);
    }

    public E get(long l) {
        if (this.spineIndex == 0) {
            if (l < (long)this.elementIndex) {
                return this.curChunk[(int)l];
            }
            throw new IndexOutOfBoundsException(Long.toString(l));
        }
        if (l >= this.count()) {
            throw new IndexOutOfBoundsException(Long.toString(l));
        }
        for (int i = 0; i <= this.spineIndex; ++i) {
            if (l >= this.priorElementCount[i] + (long)this.spine[i].length) continue;
            return this.spine[i][(int)(l - this.priorElementCount[i])];
        }
        throw new IndexOutOfBoundsException(Long.toString(l));
    }

    public void copyInto(E[] EArray, int n) {
        long l = (long)n + this.count();
        if (l > (long)EArray.length || l < (long)n) {
            throw new IndexOutOfBoundsException("does not fit");
        }
        if (this.spineIndex == 0) {
            System.arraycopy(this.curChunk, 0, EArray, n, this.elementIndex);
        } else {
            for (int i = 0; i < this.spineIndex; ++i) {
                System.arraycopy(this.spine[i], 0, EArray, n, this.spine[i].length);
                n += this.spine[i].length;
            }
            if (this.elementIndex > 0) {
                System.arraycopy(this.curChunk, 0, EArray, n, this.elementIndex);
            }
        }
    }

    public E[] asArray(IntFunction<E[]> intFunction) {
        long l = this.count();
        if (l >= 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Stream size exceeds max array size");
        }
        E[] EArray = intFunction.apply((int)l);
        this.copyInto(EArray, 0);
        return EArray;
    }

    @Override
    public void clear() {
        if (this.spine != null) {
            this.curChunk = this.spine[0];
            for (int i = 0; i < this.curChunk.length; ++i) {
                this.curChunk[i] = null;
            }
            this.spine = null;
            this.priorElementCount = null;
        } else {
            for (int i = 0; i < this.elementIndex; ++i) {
                this.curChunk[i] = null;
            }
        }
        this.elementIndex = 0;
        this.spineIndex = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        int n;
        for (n = 0; n < this.spineIndex; ++n) {
            for (E e : this.spine[n]) {
                consumer.accept(e);
            }
        }
        for (n = 0; n < this.elementIndex; ++n) {
            consumer.accept(this.curChunk[n]);
        }
    }

    @Override
    public void accept(E e) {
        if (this.elementIndex == this.curChunk.length) {
            this.inflateSpine();
            if (this.spineIndex + 1 >= this.spine.length || this.spine[this.spineIndex + 1] == null) {
                this.increaseCapacity();
            }
            this.elementIndex = 0;
            ++this.spineIndex;
            this.curChunk = this.spine[this.spineIndex];
        }
        this.curChunk[this.elementIndex++] = e;
    }

    public String toString() {
        ArrayList arrayList = new ArrayList();
        this.forEach((Consumer<? super E>)((Consumer<Object>)arrayList::add));
        return "SpinedBuffer:" + ((Object)arrayList).toString();
    }

    @Override
    public Spliterator<E> spliterator() {
        class Splitr
        implements Spliterator<E> {
            int splSpineIndex;
            final int lastSpineIndex;
            int splElementIndex;
            final int lastSpineElementFence;
            E[] splChunk;

            Splitr(int n, int n2, int n3, int n4) {
                this.splSpineIndex = n;
                this.lastSpineIndex = n2;
                this.splElementIndex = n3;
                this.lastSpineElementFence = n4;
                assert (SpinedBuffer.this.spine != null || n == 0 && n2 == 0);
                this.splChunk = SpinedBuffer.this.spine == null ? SpinedBuffer.this.curChunk : SpinedBuffer.this.spine[n];
            }

            @Override
            public long estimateSize() {
                return this.splSpineIndex == this.lastSpineIndex ? (long)this.lastSpineElementFence - (long)this.splElementIndex : SpinedBuffer.this.priorElementCount[this.lastSpineIndex] + (long)this.lastSpineElementFence - SpinedBuffer.this.priorElementCount[this.splSpineIndex] - (long)this.splElementIndex;
            }

            @Override
            public int characteristics() {
                return 16464;
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> consumer) {
                Objects.requireNonNull(consumer);
                if (this.splSpineIndex < this.lastSpineIndex || this.splSpineIndex == this.lastSpineIndex && this.splElementIndex < this.lastSpineElementFence) {
                    consumer.accept(this.splChunk[this.splElementIndex++]);
                    if (this.splElementIndex == this.splChunk.length) {
                        this.splElementIndex = 0;
                        ++this.splSpineIndex;
                        if (SpinedBuffer.this.spine != null && this.splSpineIndex <= this.lastSpineIndex) {
                            this.splChunk = SpinedBuffer.this.spine[this.splSpineIndex];
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super E> consumer) {
                Objects.requireNonNull(consumer);
                if (this.splSpineIndex < this.lastSpineIndex || this.splSpineIndex == this.lastSpineIndex && this.splElementIndex < this.lastSpineElementFence) {
                    int n = this.splElementIndex;
                    for (int i = this.splSpineIndex; i < this.lastSpineIndex; ++i) {
                        E[] EArray = SpinedBuffer.this.spine[i];
                        while (n < EArray.length) {
                            consumer.accept(EArray[n]);
                            ++n;
                        }
                        n = 0;
                    }
                    E[] EArray = this.splSpineIndex == this.lastSpineIndex ? this.splChunk : SpinedBuffer.this.spine[this.lastSpineIndex];
                    int n2 = this.lastSpineElementFence;
                    while (n < n2) {
                        consumer.accept(EArray[n]);
                        ++n;
                    }
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = this.lastSpineElementFence;
                }
            }

            @Override
            public Spliterator<E> trySplit() {
                if (this.splSpineIndex < this.lastSpineIndex) {
                    Splitr splitr = new Splitr(this.splSpineIndex, this.lastSpineIndex - 1, this.splElementIndex, SpinedBuffer.this.spine[this.lastSpineIndex - 1].length);
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = 0;
                    this.splChunk = SpinedBuffer.this.spine[this.splSpineIndex];
                    return splitr;
                }
                if (this.splSpineIndex == this.lastSpineIndex) {
                    int n = (this.lastSpineElementFence - this.splElementIndex) / 2;
                    if (n == 0) {
                        return null;
                    }
                    Spliterator spliterator = Arrays.spliterator(this.splChunk, this.splElementIndex, this.splElementIndex + n);
                    this.splElementIndex += n;
                    return spliterator;
                }
                return null;
            }
        }
        return new Splitr(0, this.spineIndex, 0, this.elementIndex);
    }

    static class OfDouble
    extends OfPrimitive<Double, double[], DoubleConsumer>
    implements DoubleConsumer {
        OfDouble() {
        }

        OfDouble(int n) {
            super(n);
        }

        @Override
        public void forEach(Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                this.forEach((DoubleConsumer)((Object)consumer));
            } else {
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling SpinedBuffer.OfDouble.forEach(Consumer)");
                }
                this.spliterator().forEachRemaining(consumer);
            }
        }

        protected double[][] newArrayArray(int n) {
            return new double[n][];
        }

        @Override
        public double[] newArray(int n) {
            return new double[n];
        }

        @Override
        protected int arrayLength(double[] dArray) {
            return dArray.length;
        }

        @Override
        protected void arrayForEach(double[] dArray, int n, int n2, DoubleConsumer doubleConsumer) {
            for (int i = n; i < n2; ++i) {
                doubleConsumer.accept(dArray[i]);
            }
        }

        @Override
        public void accept(double d) {
            this.preAccept();
            ((double[])this.curChunk)[this.elementIndex++] = d;
        }

        public double get(long l) {
            int n = this.chunkFor(l);
            if (this.spineIndex == 0 && n == 0) {
                return ((double[])this.curChunk)[(int)l];
            }
            return ((double[][])this.spine)[n][(int)(l - this.priorElementCount[n])];
        }

        public PrimitiveIterator.OfDouble iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        public Spliterator.OfDouble spliterator() {
            class Splitr
            extends OfPrimitive.BaseSpliterator<Spliterator.OfDouble>
            implements Spliterator.OfDouble {
                Splitr(int n, int n2, int n3, int n4) {
                    super(n, n2, n3, n4);
                }

                @Override
                Splitr newSpliterator(int n, int n2, int n3, int n4) {
                    return new Splitr(n, n2, n3, n4);
                }

                @Override
                void arrayForOne(double[] dArray, int n, DoubleConsumer doubleConsumer) {
                    doubleConsumer.accept(dArray[n]);
                }

                @Override
                Spliterator.OfDouble arraySpliterator(double[] dArray, int n, int n2) {
                    return Arrays.spliterator(dArray, n, n + n2);
                }
            }
            return new Splitr(0, this.spineIndex, 0, this.elementIndex);
        }

        public String toString() {
            double[] dArray = (double[])this.asPrimitiveArray();
            if (dArray.length < 200) {
                return String.format("%s[length=%d, chunks=%d]%s", this.getClass().getSimpleName(), dArray.length, this.spineIndex, Arrays.toString(dArray));
            }
            double[] dArray2 = Arrays.copyOf(dArray, 200);
            return String.format("%s[length=%d, chunks=%d]%s...", this.getClass().getSimpleName(), dArray.length, this.spineIndex, Arrays.toString(dArray2));
        }
    }

    static class OfLong
    extends OfPrimitive<Long, long[], LongConsumer>
    implements LongConsumer {
        OfLong() {
        }

        OfLong(int n) {
            super(n);
        }

        @Override
        public void forEach(Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                this.forEach((LongConsumer)((Object)consumer));
            } else {
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling SpinedBuffer.OfLong.forEach(Consumer)");
                }
                this.spliterator().forEachRemaining(consumer);
            }
        }

        protected long[][] newArrayArray(int n) {
            return new long[n][];
        }

        @Override
        public long[] newArray(int n) {
            return new long[n];
        }

        @Override
        protected int arrayLength(long[] lArray) {
            return lArray.length;
        }

        @Override
        protected void arrayForEach(long[] lArray, int n, int n2, LongConsumer longConsumer) {
            for (int i = n; i < n2; ++i) {
                longConsumer.accept(lArray[i]);
            }
        }

        @Override
        public void accept(long l) {
            this.preAccept();
            ((long[])this.curChunk)[this.elementIndex++] = l;
        }

        public long get(long l) {
            int n = this.chunkFor(l);
            if (this.spineIndex == 0 && n == 0) {
                return ((long[])this.curChunk)[(int)l];
            }
            return ((long[][])this.spine)[n][(int)(l - this.priorElementCount[n])];
        }

        public PrimitiveIterator.OfLong iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        public Spliterator.OfLong spliterator() {
            class Splitr
            extends OfPrimitive.BaseSpliterator<Spliterator.OfLong>
            implements Spliterator.OfLong {
                Splitr(int n, int n2, int n3, int n4) {
                    super(n, n2, n3, n4);
                }

                @Override
                Splitr newSpliterator(int n, int n2, int n3, int n4) {
                    return new Splitr(n, n2, n3, n4);
                }

                @Override
                void arrayForOne(long[] lArray, int n, LongConsumer longConsumer) {
                    longConsumer.accept(lArray[n]);
                }

                @Override
                Spliterator.OfLong arraySpliterator(long[] lArray, int n, int n2) {
                    return Arrays.spliterator(lArray, n, n + n2);
                }
            }
            return new Splitr(0, this.spineIndex, 0, this.elementIndex);
        }

        public String toString() {
            long[] lArray = (long[])this.asPrimitiveArray();
            if (lArray.length < 200) {
                return String.format("%s[length=%d, chunks=%d]%s", this.getClass().getSimpleName(), lArray.length, this.spineIndex, Arrays.toString(lArray));
            }
            long[] lArray2 = Arrays.copyOf(lArray, 200);
            return String.format("%s[length=%d, chunks=%d]%s...", this.getClass().getSimpleName(), lArray.length, this.spineIndex, Arrays.toString(lArray2));
        }
    }

    static class OfInt
    extends OfPrimitive<Integer, int[], IntConsumer>
    implements IntConsumer {
        OfInt() {
        }

        OfInt(int n) {
            super(n);
        }

        @Override
        public void forEach(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this.forEach((IntConsumer)((Object)consumer));
            } else {
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling SpinedBuffer.OfInt.forEach(Consumer)");
                }
                this.spliterator().forEachRemaining(consumer);
            }
        }

        protected int[][] newArrayArray(int n) {
            return new int[n][];
        }

        @Override
        public int[] newArray(int n) {
            return new int[n];
        }

        @Override
        protected int arrayLength(int[] nArray) {
            return nArray.length;
        }

        @Override
        protected void arrayForEach(int[] nArray, int n, int n2, IntConsumer intConsumer) {
            for (int i = n; i < n2; ++i) {
                intConsumer.accept(nArray[i]);
            }
        }

        @Override
        public void accept(int n) {
            this.preAccept();
            ((int[])this.curChunk)[this.elementIndex++] = n;
        }

        public int get(long l) {
            int n = this.chunkFor(l);
            if (this.spineIndex == 0 && n == 0) {
                return ((int[])this.curChunk)[(int)l];
            }
            return ((int[][])this.spine)[n][(int)(l - this.priorElementCount[n])];
        }

        public PrimitiveIterator.OfInt iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        public Spliterator.OfInt spliterator() {
            class Splitr
            extends OfPrimitive.BaseSpliterator<Spliterator.OfInt>
            implements Spliterator.OfInt {
                Splitr(int n, int n2, int n3, int n4) {
                    super(n, n2, n3, n4);
                }

                @Override
                Splitr newSpliterator(int n, int n2, int n3, int n4) {
                    return new Splitr(n, n2, n3, n4);
                }

                @Override
                void arrayForOne(int[] nArray, int n, IntConsumer intConsumer) {
                    intConsumer.accept(nArray[n]);
                }

                @Override
                Spliterator.OfInt arraySpliterator(int[] nArray, int n, int n2) {
                    return Arrays.spliterator(nArray, n, n + n2);
                }
            }
            return new Splitr(0, this.spineIndex, 0, this.elementIndex);
        }

        public String toString() {
            int[] nArray = (int[])this.asPrimitiveArray();
            if (nArray.length < 200) {
                return String.format("%s[length=%d, chunks=%d]%s", this.getClass().getSimpleName(), nArray.length, this.spineIndex, Arrays.toString(nArray));
            }
            int[] nArray2 = Arrays.copyOf(nArray, 200);
            return String.format("%s[length=%d, chunks=%d]%s...", this.getClass().getSimpleName(), nArray.length, this.spineIndex, Arrays.toString(nArray2));
        }
    }

    static abstract class OfPrimitive<E, T_ARR, T_CONS>
    extends AbstractSpinedBuffer
    implements Iterable<E> {
        T_ARR curChunk;
        T_ARR[] spine;

        OfPrimitive(int n) {
            super(n);
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        OfPrimitive() {
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract void forEach(Consumer<? super E> var1);

        protected abstract T_ARR[] newArrayArray(int var1);

        public abstract T_ARR newArray(int var1);

        protected abstract int arrayLength(T_ARR var1);

        protected abstract void arrayForEach(T_ARR var1, int var2, int var3, T_CONS var4);

        protected long capacity() {
            return this.spineIndex == 0 ? (long)this.arrayLength(this.curChunk) : this.priorElementCount[this.spineIndex] + (long)this.arrayLength(this.spine[this.spineIndex]);
        }

        private void inflateSpine() {
            if (this.spine == null) {
                this.spine = this.newArrayArray(8);
                this.priorElementCount = new long[8];
                this.spine[0] = this.curChunk;
            }
        }

        protected final void ensureCapacity(long l) {
            long l2 = this.capacity();
            if (l > l2) {
                this.inflateSpine();
                int n = this.spineIndex + 1;
                while (l > l2) {
                    int n2;
                    if (n >= this.spine.length) {
                        n2 = this.spine.length * 2;
                        this.spine = Arrays.copyOf(this.spine, n2);
                        this.priorElementCount = Arrays.copyOf(this.priorElementCount, n2);
                    }
                    n2 = this.chunkSize(n);
                    this.spine[n] = this.newArray(n2);
                    this.priorElementCount[n] = this.priorElementCount[n - 1] + (long)this.arrayLength(this.spine[n - 1]);
                    l2 += (long)n2;
                    ++n;
                }
            }
        }

        protected void increaseCapacity() {
            this.ensureCapacity(this.capacity() + 1L);
        }

        protected int chunkFor(long l) {
            if (this.spineIndex == 0) {
                if (l < (long)this.elementIndex) {
                    return 0;
                }
                throw new IndexOutOfBoundsException(Long.toString(l));
            }
            if (l >= this.count()) {
                throw new IndexOutOfBoundsException(Long.toString(l));
            }
            for (int i = 0; i <= this.spineIndex; ++i) {
                if (l >= this.priorElementCount[i] + (long)this.arrayLength(this.spine[i])) continue;
                return i;
            }
            throw new IndexOutOfBoundsException(Long.toString(l));
        }

        public void copyInto(T_ARR T_ARR, int n) {
            long l = (long)n + this.count();
            if (l > (long)this.arrayLength(T_ARR) || l < (long)n) {
                throw new IndexOutOfBoundsException("does not fit");
            }
            if (this.spineIndex == 0) {
                System.arraycopy(this.curChunk, 0, T_ARR, n, this.elementIndex);
            } else {
                for (int i = 0; i < this.spineIndex; ++i) {
                    System.arraycopy(this.spine[i], 0, T_ARR, n, this.arrayLength(this.spine[i]));
                    n += this.arrayLength(this.spine[i]);
                }
                if (this.elementIndex > 0) {
                    System.arraycopy(this.curChunk, 0, T_ARR, n, this.elementIndex);
                }
            }
        }

        public T_ARR asPrimitiveArray() {
            long l = this.count();
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            T_ARR T_ARR = this.newArray((int)l);
            this.copyInto(T_ARR, 0);
            return T_ARR;
        }

        protected void preAccept() {
            if (this.elementIndex == this.arrayLength(this.curChunk)) {
                this.inflateSpine();
                if (this.spineIndex + 1 >= this.spine.length || this.spine[this.spineIndex + 1] == null) {
                    this.increaseCapacity();
                }
                this.elementIndex = 0;
                ++this.spineIndex;
                this.curChunk = this.spine[this.spineIndex];
            }
        }

        @Override
        public void clear() {
            if (this.spine != null) {
                this.curChunk = this.spine[0];
                this.spine = null;
                this.priorElementCount = null;
            }
            this.elementIndex = 0;
            this.spineIndex = 0;
        }

        public void forEach(T_CONS T_CONS) {
            for (int i = 0; i < this.spineIndex; ++i) {
                this.arrayForEach(this.spine[i], 0, this.arrayLength(this.spine[i]), T_CONS);
            }
            this.arrayForEach(this.curChunk, 0, this.elementIndex, T_CONS);
        }

        abstract class BaseSpliterator<T_SPLITR extends Spliterator.OfPrimitive<E, T_CONS, T_SPLITR>>
        implements Spliterator.OfPrimitive<E, T_CONS, T_SPLITR> {
            int splSpineIndex;
            final int lastSpineIndex;
            int splElementIndex;
            final int lastSpineElementFence;
            T_ARR splChunk;

            BaseSpliterator(int n, int n2, int n3, int n4) {
                this.splSpineIndex = n;
                this.lastSpineIndex = n2;
                this.splElementIndex = n3;
                this.lastSpineElementFence = n4;
                assert (OfPrimitive.this.spine != null || n == 0 && n2 == 0);
                this.splChunk = OfPrimitive.this.spine == null ? OfPrimitive.this.curChunk : OfPrimitive.this.spine[n];
            }

            abstract T_SPLITR newSpliterator(int var1, int var2, int var3, int var4);

            abstract void arrayForOne(T_ARR var1, int var2, T_CONS var3);

            abstract T_SPLITR arraySpliterator(T_ARR var1, int var2, int var3);

            @Override
            public long estimateSize() {
                return this.splSpineIndex == this.lastSpineIndex ? (long)this.lastSpineElementFence - (long)this.splElementIndex : OfPrimitive.this.priorElementCount[this.lastSpineIndex] + (long)this.lastSpineElementFence - OfPrimitive.this.priorElementCount[this.splSpineIndex] - (long)this.splElementIndex;
            }

            @Override
            public int characteristics() {
                return 16464;
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                Objects.requireNonNull(T_CONS);
                if (this.splSpineIndex < this.lastSpineIndex || this.splSpineIndex == this.lastSpineIndex && this.splElementIndex < this.lastSpineElementFence) {
                    this.arrayForOne(this.splChunk, this.splElementIndex++, T_CONS);
                    if (this.splElementIndex == OfPrimitive.this.arrayLength(this.splChunk)) {
                        this.splElementIndex = 0;
                        ++this.splSpineIndex;
                        if (OfPrimitive.this.spine != null && this.splSpineIndex <= this.lastSpineIndex) {
                            this.splChunk = OfPrimitive.this.spine[this.splSpineIndex];
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                Objects.requireNonNull(T_CONS);
                if (this.splSpineIndex < this.lastSpineIndex || this.splSpineIndex == this.lastSpineIndex && this.splElementIndex < this.lastSpineElementFence) {
                    int n = this.splElementIndex;
                    for (int i = this.splSpineIndex; i < this.lastSpineIndex; ++i) {
                        Object T_ARR = OfPrimitive.this.spine[i];
                        OfPrimitive.this.arrayForEach(T_ARR, n, OfPrimitive.this.arrayLength(T_ARR), T_CONS);
                        n = 0;
                    }
                    Object T_ARR = this.splSpineIndex == this.lastSpineIndex ? this.splChunk : OfPrimitive.this.spine[this.lastSpineIndex];
                    OfPrimitive.this.arrayForEach(T_ARR, n, this.lastSpineElementFence, T_CONS);
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = this.lastSpineElementFence;
                }
            }

            @Override
            public T_SPLITR trySplit() {
                if (this.splSpineIndex < this.lastSpineIndex) {
                    T_SPLITR T_SPLITR = this.newSpliterator(this.splSpineIndex, this.lastSpineIndex - 1, this.splElementIndex, OfPrimitive.this.arrayLength(OfPrimitive.this.spine[this.lastSpineIndex - 1]));
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = 0;
                    this.splChunk = OfPrimitive.this.spine[this.splSpineIndex];
                    return T_SPLITR;
                }
                if (this.splSpineIndex == this.lastSpineIndex) {
                    int n = (this.lastSpineElementFence - this.splElementIndex) / 2;
                    if (n == 0) {
                        return null;
                    }
                    T_SPLITR T_SPLITR = this.arraySpliterator(this.splChunk, this.splElementIndex, n);
                    this.splElementIndex += n;
                    return T_SPLITR;
                }
                return null;
            }
        }
    }
}

