/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class InfoFromMemberName
implements MethodHandleInfo {
    private final MemberName member;
    private final int referenceKind;

    InfoFromMemberName(MethodHandles.Lookup lookup, MemberName memberName, byte by) {
        assert (memberName.isResolved() || memberName.isMethodHandleInvoke());
        assert (memberName.referenceKindIsConsistentWith(by));
        this.member = memberName;
        this.referenceKind = by;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.member.getName();
    }

    @Override
    public MethodType getMethodType() {
        return this.member.getMethodOrFieldType();
    }

    @Override
    public int getModifiers() {
        return this.member.getModifiers();
    }

    @Override
    public int getReferenceKind() {
        return this.referenceKind;
    }

    public String toString() {
        return MethodHandleInfo.toString(this.getReferenceKind(), this.getDeclaringClass(), this.getName(), this.getMethodType());
    }

    @Override
    public <T extends Member> T reflectAs(Class<T> clazz, MethodHandles.Lookup lookup) {
        if (this.member.isMethodHandleInvoke() && !this.member.isVarargs()) {
            throw new IllegalArgumentException("cannot reflect signature polymorphic method");
        }
        Member member = AccessController.doPrivileged(new PrivilegedAction<Member>(){

            @Override
            public Member run() {
                try {
                    return InfoFromMemberName.this.reflectUnchecked();
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalArgumentException(reflectiveOperationException);
                }
            }
        });
        try {
            Class<?> clazz2 = this.getDeclaringClass();
            byte by = (byte)this.getReferenceKind();
            lookup.checkAccess(by, clazz2, InfoFromMemberName.convertToMemberName(by, member));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        return (T)((Member)clazz.cast(member));
    }

    private Member reflectUnchecked() throws ReflectiveOperationException {
        byte by = (byte)this.getReferenceKind();
        Class<?> clazz = this.getDeclaringClass();
        boolean bl = Modifier.isPublic(this.getModifiers());
        if (MethodHandleNatives.refKindIsMethod(by)) {
            if (bl) {
                return clazz.getMethod(this.getName(), this.getMethodType().parameterArray());
            }
            return clazz.getDeclaredMethod(this.getName(), this.getMethodType().parameterArray());
        }
        if (MethodHandleNatives.refKindIsConstructor(by)) {
            if (bl) {
                return clazz.getConstructor(this.getMethodType().parameterArray());
            }
            return clazz.getDeclaredConstructor(this.getMethodType().parameterArray());
        }
        if (MethodHandleNatives.refKindIsField(by)) {
            if (bl) {
                return clazz.getField(this.getName());
            }
            return clazz.getDeclaredField(this.getName());
        }
        throw new IllegalArgumentException("referenceKind=" + by);
    }

    private static MemberName convertToMemberName(byte by, Member member) throws IllegalAccessException {
        if (member instanceof Method) {
            boolean bl = by == 7;
            return new MemberName((Method)member, bl);
        }
        if (member instanceof Constructor) {
            return new MemberName((Constructor)member);
        }
        if (member instanceof Field) {
            boolean bl = by == 3 || by == 4;
            return new MemberName((Field)member, bl);
        }
        throw new InternalError(member.getClass().getName());
    }
}

