/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.util;

public class Misc {
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String toHex(int addr) {
        char[] buf = new char[8];
        int i = 0;
        for (int s = 28; s >= 0; s -= 4) {
            buf[i++] = digits[addr >> s & 0xF];
        }
        return "0x" + new String(buf);
    }

    public static final String toHex(long addr) {
        return "0x" + Long.toHexString(addr);
    }

    public static final long parseHex(String value) {
        long result = 0L;
        if (value.length() < 2 || value.charAt(0) != '0' || value.charAt(1) != 'x') {
            return -1L;
        }
        for (int i = 2; i < value.length(); ++i) {
            result *= 16L;
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') {
                result += (long)(ch - 48);
                continue;
            }
            if (ch >= 'a' && ch <= 'f') {
                result += (long)(ch - 97 + 10);
                continue;
            }
            if (ch >= 'A' && ch <= 'F') {
                result += (long)(ch - 65 + 10);
                continue;
            }
            throw new NumberFormatException(ch + " is not a valid hex digit");
        }
        return result;
    }

    public static String encodeHtml(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                sb.append("&#039;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch < ' ') {
                sb.append("&#").append((int)ch).append(';');
                continue;
            }
            int c = ch & 0xFFFF;
            if (c > 127) {
                sb.append("&#").append(c).append(';');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

