/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.artifacts;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import jdk.test.lib.artifacts.Artifact;
import jdk.test.lib.artifacts.ArtifactContainer;
import jdk.test.lib.artifacts.ArtifactManager;
import jdk.test.lib.artifacts.ArtifactResolverException;
import jdk.test.lib.artifacts.DefaultArtifactManager;
import jdk.test.lib.artifacts.JibArtifactManager;
import jtreg.SkippedException;

public class ArtifactResolver {
    private static ArtifactManager getManager() throws ArtifactResolverException {
        ArtifactManager manager;
        try {
            String managerName = System.getProperty("jdk.test.lib.artifacts.artifactmanager");
            manager = managerName != null ? (ArtifactManager)Class.forName(managerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (System.getenv().containsKey("JIB_HOME") ? JibArtifactManager.newInstance() : new DefaultArtifactManager());
        }
        catch (Exception e) {
            throw new ArtifactResolverException("Failed to load ArtifactManager", e);
        }
        return manager;
    }

    public static Map<String, Path> resolve(Class<?> klass) throws ArtifactResolverException {
        ArtifactManager manager = ArtifactResolver.getManager();
        ArtifactContainer artifactContainer = klass.getAnnotation(ArtifactContainer.class);
        HashMap<String, Path> locations = new HashMap<String, Path>();
        Artifact[] artifacts = artifactContainer == null ? new Artifact[]{klass.getAnnotation(Artifact.class)} : artifactContainer.value();
        for (Artifact artifact : artifacts) {
            locations.put(ArtifactResolver.artifactName(artifact), manager.resolve(artifact));
        }
        return locations;
    }

    public static Path resolve(String name, Map<String, Object> artifactDescription, boolean unpack) throws ArtifactResolverException {
        ArtifactManager manager = ArtifactResolver.getManager();
        return manager.resolve(name, artifactDescription, unpack);
    }

    public static Path fetchOne(Class<?> klass) {
        try {
            return (Path)((Map.Entry)ArtifactResolver.resolve(klass).entrySet().stream().findAny().get()).getValue();
        }
        catch (ArtifactResolverException e) {
            Artifact artifact = klass.getAnnotation(Artifact.class);
            throw new SkippedException("Cannot find the artifact " + artifact.name(), e);
        }
    }

    private static String artifactName(Artifact artifact) {
        Object name = String.format("%s.%s-%s", artifact.organization(), artifact.name(), artifact.revision());
        if (artifact.classifier().length() != 0) {
            name = (String)name + "-" + artifact.classifier();
        }
        return name;
    }
}

