/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.ByteArrayInputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.SecurityTools;
import jdk.test.lib.process.OutputAnalyzer;

public enum TestCertificate {
    ONE("10:00", "CN=SSLCertificate, O=SomeCompany", "CN=Intermediate CA Cert, O=SomeCompany", -1063259762, "-----BEGIN CERTIFICATE-----\nMIIDnTCCAoWgAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwNTEUMBIGA1UEChMLU29t\nZUNvbXBhbnkxHTAbBgNVBAMTFEludGVybWVkaWF0ZSBDQSBDZXJ0MB4XDTE2MDgz\nMDIxMzcxOVoXDTE3MDgzMDIxMzcxOVowLzEUMBIGA1UEChMLU29tZUNvbXBhbnkx\nFzAVBgNVBAMTDlNTTENlcnRpZmljYXRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEAjgv8KKE4CO0rbCjRLA1hXjRiSq30jeusCJ8frbRG+QOBgQ3j6jgc\nvk5wG1aTu7R4AFn0/HRDMzP9ZbRlZVIbJUTd8YiaNyZeyWapPnxHWrPCd5e1xopk\nElieDdEH5FiLGtIrWy56CGA1hfQb1vUVYegyeY+TTtMFVHt0PrmMk4ZRgj/GtVNp\nBQQYIzaYAcrcWMeCn30ZrhaGAL1hsdgmEVV1wsTD4JeNMSwLwMYem7fg8ondGZIR\nkZuGtuSdOHu4Xz+mgDNXTeX/Bp/dQFucxCG+FOOM9Hoz72RY2W8YqgL38RlnwYWp\nnUNxhXWFH6vyINRQVEu3IgahR6HXjxM7LwIDAQABo4G8MIG5MBQGA1UdEQQNMAuC\nCWxvY2FsaG9zdDAyBggrBgEFBQcBAQQmMCQwIgYIKwYBBQUHMAGGFmh0dHA6Ly9s\nb2NhbGhvc3Q6NDIzMzMwHwYDVR0jBBgwFoAUYT525lwHCI4CmuWs8a7poaeKRJ4w\nHQYDVR0OBBYEFCaQnOX4L1ovqyfeKuoay+kI+lXgMA4GA1UdDwEB/wQEAwIFoDAd\nBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDQYJKoZIhvcNAQELBQADggEB\nAD8dqQIqFasJcL8lm4mPTsBl0JgNiN8tQcXM7VCvcH+yDvEyh9vudDjuhpSORqPq\nf1o/EvJ+gfs269mBnYQujYRvmSd6EAcBntv5zn6amOh03o6PqTY9KaUC/mL9hB84\nY5/LYioP16sME7egKnlrGUgKh0ZvGzm7c3SYx3Z5YoeFBOkZajc7Jm+cBw/uBQkF\na9mLEczIvOgkq1wto8vr2ptH1gEuvFRcorN3muvq34bk40G08+AHlP3fCLFpI3FA\nIStJLJZRcO+Ib4sOcKuaBGnuMo/QVOCEMDUs6RgiWtSd93OZKFIUOASVp6YIkcSs\n5/rmc06sICqBjLfPEB68Jjw=\n-----END CERTIFICATE-----"),
    TWO("64", "CN=Intermediate CA Cert, O=SomeCompany", "CN=Root CA Cert, O=SomeCompany", -927189373, "-----BEGIN CERTIFICATE-----\nMIIDdjCCAl6gAwIBAgIBZDANBgkqhkiG9w0BAQsFADAtMRQwEgYDVQQKEwtTb21l\nQ29tcGFueTEVMBMGA1UEAxMMUm9vdCBDQSBDZXJ0MB4XDTE2MDgwNzIxMzcxOVoX\nDTE4MDgwNzIxMzcxOVowNTEUMBIGA1UEChMLU29tZUNvbXBhbnkxHTAbBgNVBAMT\nFEludGVybWVkaWF0ZSBDQSBDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAnJR5CnE7GKlQjigExSJ6hHu302mc0PcA6TDgsIitPYD/r8RBbBuE51OQ\n7IP7AXmfPUV3/+pO/uxx6mgY5O6XeUl7KadhVPtPcL0BVVevCSOdTMVa3iV4zRpa\nC6Uy2ouUFnafKnDtlbieggyETUoNgVNJYA9L0XNhtSnENoLHC4Pq0v8OsNtsOWFR\nNiMTOA49NNDBw85WgPyFAxjqO4z0J0zxdWq3W4rSMB8xrkulv2Rvj3GcfYJK/ab8\nV1IJ6PMWCpujASY3BzvYPnN7BKuBjbWJPgZdPYfX1cxeG80u0tOuMfWWiNONSMSA\n7m9y304QA0gKqlrFFn9U4hU89kv1IwIDAQABo4GYMIGVMA8GA1UdEwEB/wQFMAMB\nAf8wMgYIKwYBBQUHAQEEJjAkMCIGCCsGAQUFBzABhhZodHRwOi8vbG9jYWxob3N0\nOjM5MTM0MB8GA1UdIwQYMBaAFJNMsejEyJUB9tiWycVczvpiMVQZMB0GA1UdDgQW\nBBRhPnbmXAcIjgKa5azxrumhp4pEnjAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcN\nAQELBQADggEBAE4nOFdW9OirPnRvxihQXYL9CXLuGQz5tr0XgN8wSY6Un9b6CRiK\n7obgIGimVdhvUC1qdRcwJqgOfJ2/jR5/5Qo0TVp+ww4dHNdUoj73tagJ7jTu0ZMz\n5Zdp0uwd4RD/syvTeVcbPc3m4awtgEvRgzpDMcSeKPZWInlo7fbnowKSAUAfO8de\n0cDkxEBkzPIzGNu256cdLZOqOK9wLJ9mQ0zKgi/2NsldNc2pl/6jkGpA6uL5lJsm\nfo9sDusWNHV1YggqjDQ19hrf40VuuC9GFl/qAW3marMuEzY/NiKVUxty1q1s48SO\ng5LoEPDDkbygOt7ICL3HYG1VufhC1Q2YY9c=\n-----END CERTIFICATE-----"),
    ROOT_CA("1", "CN=Root CA Cert, O=SomeCompany", "CN=Root CA Cert, O=SomeCompany", -1299818863, "-----BEGIN CERTIFICATE-----\nMIIDODCCAiCgAwIBAgIBATANBgkqhkiG9w0BAQsFADAtMRQwEgYDVQQKEwtTb21l\nQ29tcGFueTEVMBMGA1UEAxMMUm9vdCBDQSBDZXJ0MB4XDTE2MDcwODIxMzcxOFoX\nDTE5MDYyODIxMzcxOFowLTEUMBIGA1UEChMLU29tZUNvbXBhbnkxFTATBgNVBAMT\nDFJvb3QgQ0EgQ2VydDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIlN\nM3WYEqkU2elXEZrV9QSDbDKwyaLEHafLFciH8Edoag3q/7jEzFJxI7JZ831tdbWQ\nBm6Hgo+8pvetOFW1BckL8eIjyOONP2CKfFaeMaozsWi1cgxa+rjpU/Rekc+zBqvv\ny4Sr97TwT6nQiLlgjC1nCfR1SVpO51qoDChS7n785rsKEZxw/p+kkVWSZffU7zN9\nc645cPg//L/kjiyeKMkaquGQOYS68gQgy8YZXQv1E3l/8e8Ci1s1DYA5wpCbaBqg\nTw84Rr4zlUEQBgXzQlRt+mPzeaDpdG1EeGkXrcdkZ+0EMELoOVXOEn6VNsz6vT3I\nKrnvQBSnN06xq/iWwC0CAwEAAaNjMGEwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSME\nGDAWgBSTTLHoxMiVAfbYlsnFXM76YjFUGTAdBgNVHQ4EFgQUk0yx6MTIlQH22JbJ\nxVzO+mIxVBkwDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEBCwUAA4IBAQAAi+Nl\nsxP9t2IhiZIHRJGSBZuQlXIjwYIwbq3ZWc/ApZ+0oxtl7DYQi5uRNt8/opcGNCHc\nIY0fG93SbkDubXbxPYBW6D/RUjbz59ZryaP5ym55p1MjHTOqy+AM8g41xNTJikc3\nUUFXXnckeFbawijCsb7vf71owzKuxgBXi9n1rmXXtncKoA/LrUVXoUlKefdgDnsU\nsl3Q29eibE3HSqziMMoAOLm0jjekFGWIgLeTtyRYR1d0dNaUwsHTrQpPjxxUTn1x\nsAPpXKfzPnsYAZeeiaaE75GwbWlHzrNinvxdZQd0zctpfBJfVqD/+lWANlw+rOaK\nJ2GyCaJINsyaI/I2\n-----END CERTIFICATE-----");

    private static final CertificateFactory CERTIFICATE_FACTORY;
    public String serialNumber;
    public String algorithm;
    public String subject;
    public String issuer;
    public String keyType;
    public long certId;
    public int keyLength;
    public String encoded;

    private TestCertificate(String serialNumber, String subject, String issuer, int hash, String encoded) {
        this.serialNumber = serialNumber;
        this.subject = subject;
        this.issuer = issuer;
        this.algorithm = "SHA256withRSA";
        this.encoded = encoded;
        this.certId = Integer.toUnsignedLong(hash);
        this.keyType = "RSA";
        this.keyLength = 2048;
    }

    private static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public X509Certificate certificate() throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(this.encoded.getBytes());
        return (X509Certificate)CERTIFICATE_FACTORY.generateCertificate(is);
    }

    public static Collection<? extends Certificate> certificates() throws CertificateException {
        ByteArrayInputStream is1 = new ByteArrayInputStream((TestCertificate.ONE.encoded + "\n").getBytes());
        ByteArrayInputStream is2 = new ByteArrayInputStream(TestCertificate.TWO.encoded.getBytes());
        return CERTIFICATE_FACTORY.generateCertificates(new SequenceInputStream(is1, is2));
    }

    public static void certPath() throws CertificateException {
        CertPath cp = CERTIFICATE_FACTORY.generateCertPath(List.of(ONE.certificate(), TWO.certificate()));
        byte[] encoded = cp.getEncoded("PKCS7");
        CERTIFICATE_FACTORY.generateCertPath(new ByteArrayInputStream(encoded), "PKCS7");
    }

    public static void keyToolTest() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<configuration version=\"2.0\" description=\"test\">\n    <event name=\"jdk.X509Certificate\">\n       <setting name=\"enabled\">true</setting>\n       <setting name=\"stackTrace\">true</setting>\n    </event>\n</configuration>";
        Files.writeString(Path.of("config.jfc", new String[0]), (CharSequence)config, new OpenOption[0]);
        SecurityTools.keytool("-J-XX:StartFlightRecording=filename=keytool.jfr,settings=config.jfc", "-genkeypair", "-alias", "testkey", "-keyalg", "RSA", "-keysize", "2048", "-dname", "CN=8292033.oracle.com,OU=JPG,C=US", "-keypass", "changeit", "-validity", "365", "-keystore", "keystore.pkcs12", "-storepass", "changeit").shouldHaveExitValue(0);
        TestCertificate.jfrTool("keytool.jfr").shouldContain("8292033.oracle.com").shouldNotContain("algorithm = N/A").shouldHaveExitValue(0);
    }

    private static OutputAnalyzer jfrTool(String jfrFile) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(JDKToolFinder.getJDKTool("jfr"), "print", "--events", "jdk.X509Certificate", jfrFile);
        return new OutputAnalyzer(pb.start());
    }

    public static void generateChain(boolean selfSignedTest, boolean trustAnchorCert) throws Exception {
        Date testDate = new Date(1473199941000L);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate c1 = ONE.certificate();
        X509Certificate c2 = TWO.certificate();
        X509Certificate ca = ROOT_CA.certificate();
        TrustAnchor ta = trustAnchorCert ? new TrustAnchor(ca, null) : new TrustAnchor(ca.getIssuerX500Principal(), ca.getPublicKey(), null);
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        PKIXParameters params = new PKIXParameters(Collections.singleton(ta));
        params.setRevocationEnabled(false);
        params.setDate(testDate);
        if (!selfSignedTest) {
            CertPath path = cf.generateCertPath(List.of(c1, c2));
            validator.validate(path, params);
        } else {
            CertPath path = cf.generateCertPath(List.of(ca));
            validator.validate(path, params);
        }
    }

    static {
        CERTIFICATE_FACTORY = TestCertificate.getCertificateFactory();
    }
}

