/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security.timestamp;

import java.security.cert.X509Certificate;
import java.util.Objects;
import jdk.test.lib.security.timestamp.RespInterceptor;
import jdk.test.lib.security.timestamp.TsaParam;

public class DefaultRespInterceptor<T extends TsaParam>
implements RespInterceptor {
    private final T param;

    public DefaultRespInterceptor(T param) {
        Objects.requireNonNull(param);
        this.param = param;
    }

    @Override
    public X509Certificate[] getSignerCertChain(X509Certificate[] signerCertChain, boolean certReq) throws Exception {
        X509Certificate[] certChain = RespInterceptor.super.getSignerCertChain(signerCertChain, certReq);
        if (((TsaParam)this.param).certReq() == null) {
            return certChain;
        }
        if (((TsaParam)this.param).certReq().booleanValue()) {
            return signerCertChain;
        }
        return new X509Certificate[0];
    }

    @Override
    public String getSigAlgo(String sigAlgo) throws Exception {
        return ((TsaParam)this.param).sigAlgo() == null ? sigAlgo : ((TsaParam)this.param).sigAlgo();
    }

    @Override
    public TsaParam getRespParam(TsaParam reqParam) {
        TsaParam respParam = RespInterceptor.super.getRespParam(reqParam);
        respParam.version(((TsaParam)this.param).version() == null ? respParam.version() : ((TsaParam)this.param).version());
        respParam.status(((TsaParam)this.param).status() == null ? respParam.status() : ((TsaParam)this.param).status());
        respParam.policyId(((TsaParam)this.param).policyId() == null ? respParam.policyId() : ((TsaParam)this.param).policyId());
        respParam.digestAlgo(((TsaParam)this.param).digestAlgo() == null ? respParam.digestAlgo() : ((TsaParam)this.param).digestAlgo());
        respParam.hashedMessage(((TsaParam)this.param).hashedMessage() == null ? respParam.hashedMessage() : ((TsaParam)this.param).hashedMessage());
        respParam.genTime(((TsaParam)this.param).genTime() == null ? respParam.genTime() : ((TsaParam)this.param).genTime());
        return respParam;
    }
}

