/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.util.Objects;

public class InfiniteLoop
implements Runnable {
    private final Runnable target;
    private final long mills;

    public InfiniteLoop(Runnable target, long mills) {
        Objects.requireNonNull(target);
        if (mills < 0L) {
            throw new IllegalArgumentException("mills < 0");
        }
        this.target = target;
        this.mills = mills;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.target.run();
                if (this.mills <= 0L) continue;
                Thread.sleep(this.mills);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Error(e);
        }
    }
}

