/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.jfr.Recording;
import jdk.jfr.consumer.RecordedEvent;
import jdk.test.lib.Asserts;
import jdk.test.lib.jfr.Events;
import jdk.test.lib.jfr.SimpleEvent;

public class SimpleEventHelper {
    public static void enable(Recording r, boolean isEnabled) {
        if (isEnabled) {
            r.enable(SimpleEvent.class).withThreshold(Duration.ofMillis(0L)).withoutStackTrace();
        } else {
            r.disable(SimpleEvent.class);
        }
    }

    public static SimpleEvent createEvent(int id) {
        SimpleEvent event = new SimpleEvent();
        event.begin();
        event.id = id;
        event.end();
        event.commit();
        return event;
    }

    public static void verifyEvents(Recording r, int ... ids) throws Exception {
        ArrayList<Integer> eventIds = new ArrayList<Integer>();
        for (RecordedEvent event : Events.fromRecording(r)) {
            if (!Events.isEventType(event, SimpleEvent.class.getName())) continue;
            int id = (Integer)Events.assertField(event, "id").getValue();
            System.out.printf("recording %s: event.id=%d%n", r.getName(), id);
            eventIds.add(id);
        }
        Asserts.assertEquals(eventIds.size(), ids.length, "Wrong number of events");
        for (int i = 0; i < ids.length; ++i) {
            Asserts.assertEquals((int)((Integer)eventIds.get(i)), ids[i], "Wrong id in event");
        }
    }

    public static void verifyContains(List<RecordedEvent> events, int ... ids) throws Exception {
        HashSet<Integer> missingIds = new HashSet<Integer>();
        for (int id2 : ids) {
            missingIds.add(id2);
        }
        Object object = SimpleEventHelper.getSimpleEvents(events).iterator();
        while (object.hasNext()) {
            RecordedEvent event = (RecordedEvent)object.next();
            int id3 = (Integer)Events.assertField(event, "id").getValue();
            System.out.printf("event.id=%d%n", id3);
            missingIds.remove(id3);
        }
        if (!missingIds.isEmpty()) {
            missingIds.forEach(id -> System.out.println("Missing MyEvent with id " + id));
            Asserts.fail("Missing some MyEvent events");
        }
    }

    public static void verifyNotContains(List<RecordedEvent> events, int ... ids) throws Exception {
        for (RecordedEvent event : SimpleEventHelper.getSimpleEvents(events)) {
            int eventId = (Integer)Events.assertField(event, "id").getValue();
            System.out.printf("event.id=%d%n", eventId);
            for (int id : ids) {
                Events.assertField(event, "id").notEqual(id);
            }
        }
    }

    public static List<RecordedEvent> getSimpleEvents(List<RecordedEvent> events) {
        ArrayList<RecordedEvent> myEvents = new ArrayList<RecordedEvent>();
        for (RecordedEvent event : events) {
            if (!Events.isEventType(event, SimpleEvent.class.getName())) continue;
            myEvents.add(event);
        }
        return myEvents;
    }
}

