/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.whitebox.cpuinfo;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.test.whitebox.WhiteBox;

public class CPUInfo {
    private static final List<String> features;
    private static final String additionalCPUInfo;

    public static String getAdditionalCPUInfo() {
        return additionalCPUInfo;
    }

    public static List<String> getFeatures() {
        return features;
    }

    public static boolean hasFeature(String feature) {
        return features.contains(feature.toLowerCase());
    }

    static {
        String cpuFeaturesString;
        WhiteBox wb = WhiteBox.getWhiteBox();
        Pattern additionalCPUInfoRE = Pattern.compile("([^(]*\\([^)]*\\)[^,]*),\\s*");
        Matcher matcher = additionalCPUInfoRE.matcher(cpuFeaturesString = wb.getCPUFeatures());
        additionalCPUInfo = matcher.find() ? matcher.group(1) : "";
        String[] splittedFeatures = matcher.replaceAll("").split("(, )| ");
        features = Collections.unmodifiableList(Arrays.asList(splittedFeatures));
    }
}

