/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java2d.DemoPanel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PerformanceMonitor
extends JPanel {
    Surface surf;

    public PerformanceMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Performance"));
        this.surf = new Surface(this);
        this.add(this.surf);
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        private BufferedImage bimg;
        private Font font;
        private JPanel panel;
        final /* synthetic */ PerformanceMonitor this$0;

        public Surface(PerformanceMonitor this$0) {
            PerformanceMonitor performanceMonitor = this$0;
            Objects.requireNonNull(performanceMonitor);
            this.this$0 = performanceMonitor;
            this.font = new Font("Serif", 0, 12);
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ Surface this$1;
                {
                    Surface surface = this$1;
                    Objects.requireNonNull(surface);
                    this.this$1 = surface;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.this$1.thread == null) {
                        this.this$1.start();
                    } else {
                        this.this$1.stop();
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int textH = this.getFontMetrics(this.font).getHeight();
            return new Dimension(135, 2 + textH * 4);
        }

        @Override
        public void paint(Graphics g) {
            if (this.bimg != null) {
                g.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("PerformanceMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.setSurfaceState();
            this.notify();
        }

        public void setSurfaceState() {
            if (this.panel != null) {
                for (Component comp : this.panel.getComponents()) {
                    if (((DemoPanel)comp).surface == null) continue;
                    ((DemoPanel)comp).surface.setMonitor(this.thread != null);
                }
            }
        }

        public void setPanel(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            Dimension d = new Dimension(0, 0);
            Graphics2D big = null;
            FontMetrics fm = null;
            int ascent = 0;
            int descent = 0;
            while (this.thread == me && this.isShowing()) {
                if (this.getWidth() != d.width || this.getHeight() != d.height) {
                    d = this.getSize();
                    this.bimg = (BufferedImage)this.createImage(d.width, d.height);
                    big = this.bimg.createGraphics();
                    big.setFont(this.font);
                    fm = big.getFontMetrics();
                    ascent = fm.getAscent();
                    descent = fm.getDescent();
                    this.setSurfaceState();
                }
                big.setBackground(this.getBackground());
                big.clearRect(0, 0, d.width, d.height);
                if (this.panel == null) continue;
                big.setColor(Color.green);
                int ssH = 1;
                for (Component comp : this.panel.getComponents()) {
                    String pStr;
                    if (((DemoPanel)comp).surface == null || (pStr = ((DemoPanel)comp).surface.perfStr) == null) continue;
                    big.drawString(pStr, 4, (ssH += ascent) + 1);
                    ssH += descent;
                }
                this.repaint();
                try {
                    Thread.sleep(999L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

