/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.threaddump;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import jdk.test.lib.json.JSONValue;

public final class ThreadDump {
    private final long processId;
    private final String time;
    private final String runtimeVersion;
    private ThreadContainer rootThreadContainer;

    private ThreadDump(String json) {
        JSONValue threadDumpObj = JSONValue.parse(json).get("threadDump");
        HashMap<String, ThreadContainer> map = new HashMap<String, ThreadContainer>();
        JSONValue threadContainersObj = threadDumpObj.get("threadContainers");
        for (JSONValue containerObj : threadContainersObj.asArray()) {
            ThreadContainer parent;
            String name = containerObj.get("container").asString();
            String parentName = containerObj.get("parent").asString();
            String owner = containerObj.get("owner").asString();
            JSONValue.JSONArray threadsObj = containerObj.get("threads").asArray();
            HashSet<ThreadInfo> threadInfos = new HashSet<ThreadInfo>();
            for (JSONValue threadObj : threadsObj) {
                long tid = Long.parseLong(threadObj.get("tid").asString());
                String threadName = threadObj.get("name").asString();
                JSONValue.JSONArray stackObj = threadObj.get("stack").asArray();
                ArrayList<String> stack = new ArrayList<String>();
                for (JSONValue steObject : stackObj) {
                    stack.add(steObject.asString());
                }
                threadInfos.add(new ThreadInfo(tid, threadName, stack));
            }
            ThreadContainer container = map.computeIfAbsent(name, k -> new ThreadContainer(name));
            if (owner != null) {
                container.owner = Long.parseLong(owner);
            }
            container.threads = threadInfos;
            if (parentName == null) {
                this.rootThreadContainer = container;
                continue;
            }
            container.parent = parent = map.computeIfAbsent(parentName, k -> new ThreadContainer(parentName));
            parent.children.add(container);
        }
        this.processId = Long.parseLong(threadDumpObj.get("processId").asString());
        this.time = threadDumpObj.get("time").asString();
        this.runtimeVersion = threadDumpObj.get("runtimeVersion").asString();
    }

    public long processId() {
        return this.processId;
    }

    public String time() {
        return this.time;
    }

    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public ThreadContainer rootThreadContainer() {
        return this.rootThreadContainer;
    }

    public Optional<ThreadContainer> findThreadContainer(String name) {
        ThreadContainer container = this.rootThreadContainer.findThreadContainer(name);
        return Optional.ofNullable(container);
    }

    public static ThreadDump parse(String json) {
        return new ThreadDump(json);
    }

    public static final class ThreadInfo {
        private final long tid;
        private final String name;
        private final List<String> stack;

        ThreadInfo(long tid, String name, List<String> stack) {
            this.tid = tid;
            this.name = name;
            this.stack = stack;
        }

        public long tid() {
            return this.tid;
        }

        public String name() {
            return this.name;
        }

        public Stream<String> stack() {
            return this.stack.stream();
        }

        public int hashCode() {
            return Long.hashCode(this.tid);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadInfo) {
                ThreadInfo other = (ThreadInfo)obj;
                return this.tid == other.tid;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("#");
            sb.append(this.tid);
            if (this.name.length() > 0) {
                sb.append(",");
                sb.append(this.name);
            }
            return sb.toString();
        }
    }

    public static class ThreadContainer {
        private final String name;
        private long owner;
        private ThreadContainer parent;
        private Set<ThreadInfo> threads;
        private final Set<ThreadContainer> children = new HashSet<ThreadContainer>();

        ThreadContainer(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public OptionalLong owner() {
            return this.owner != 0L ? OptionalLong.of(this.owner) : OptionalLong.empty();
        }

        public Optional<ThreadContainer> parent() {
            return Optional.ofNullable(this.parent);
        }

        public Stream<ThreadContainer> children() {
            return this.children.stream();
        }

        public Stream<ThreadInfo> threads() {
            return this.threads.stream();
        }

        public Optional<ThreadInfo> findThread(long tid) {
            return this.threads().filter(ti -> ti.tid() == tid).findAny();
        }

        ThreadContainer findThreadContainer(String name) {
            if (this.name().equals(name)) {
                return this;
            }
            if (this.name().startsWith(name + "/")) {
                return this;
            }
            return this.children().map(c -> c.findThreadContainer(name)).filter(c -> c != null).findAny().orElse(null);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadContainer) {
                ThreadContainer other = (ThreadContainer)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

