/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionToStringUtil;

public class EndTagOpenRegion
implements ITextRegion {
    private static final String fType = "XML_END_TAG_OPEN";
    private int fLength;
    private int fStart;
    private static final byte fTextLength = 2;

    public EndTagOpenRegion() {
    }

    public EndTagOpenRegion(int start, int textLength, int length) {
        this();
        this.fStart = start;
        if (2 != textLength) {
            throw new RuntimeException("invalid for this region type");
        }
        this.fLength = length;
    }

    public EndTagOpenRegion(int start, int length) {
        this();
        this.fStart = start;
        this.fLength = length;
    }

    public void adjustLength(int i) {
        this.fLength += i;
    }

    public void adjustStart(int i) {
        this.fStart += i;
    }

    public void adjustTextLength(int i) {
        throw new RuntimeException("invalid for this region type");
    }

    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
    }

    public int getEnd() {
        return this.fStart + this.fLength;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getTextEnd() {
        return this.fStart + 2;
    }

    public int getTextLength() {
        return 2;
    }

    public String getType() {
        return fType;
    }

    public String toString() {
        return RegionToStringUtil.toString(this);
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        return null;
    }
}

