/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class FlexibleSignalsViewEventHandler
extends DebugEventHandler {
    private Object fTarget;

    public FlexibleSignalsViewEventHandler(AbstractModelProxy proxy, Object target) {
        super(proxy);
        this.fTarget = target;
    }

    protected boolean handlesEvent(DebugEvent event) {
        int kind = event.getKind();
        return kind == 4 || kind == 8 || kind == 16 || kind == 2;
    }

    protected void handleChange(DebugEvent event) {
        if (event.getSource() instanceof ICSignal) {
            this.fireDelta((ICSignal)event.getSource(), 2048);
        }
    }

    protected void handleCreate(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugTarget) {
            this.refreshRoot(event);
        } else if (source instanceof ICSignal && this.accept((ICSignal)source)) {
            ICSignal signal = (ICSignal)source;
            this.fireDelta(signal, 1);
        }
    }

    protected void handleTerminate(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugTarget) {
            this.refreshRoot(event);
        } else if (source instanceof ICSignal) {
            this.fireDelta((ICSignal)source, 2);
        }
    }

    private void fireDelta(ICSignal signal, int flags) {
        ModelDelta root = new ModelDelta(this.fTarget, 0);
        root.addNode((Object)signal, flags);
        this.fireDelta((IModelDelta)root);
    }

    public synchronized void dispose() {
        super.dispose();
        this.fTarget = null;
    }

    private boolean accept(ICSignal signal) {
        return this.fTarget.equals(signal.getDebugTarget());
    }
}

