/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree.uiwidgets;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.event.PatternEvent;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UISelectWidget
extends InputUIElement {
    protected Label label;
    protected Combo combo;
    protected Map<String, String> value2name;
    protected String defaultValue;
    protected String currentValue;

    public UISelectWidget(UIAttributes attribute, Map<String, String> value2name, String defaultValue) {
        super(attribute);
        this.value2name = value2name;
        this.defaultValue = defaultValue;
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.currentValue != null) {
            values.put((String)this.uiAttributes.get("id"), this.currentValue);
        }
        return values;
    }

    @Override
    public void setValues(Map<String, String> valueMap) {
        this.defaultValue = valueMap.get(this.uiAttributes.get("id"));
        if (this.combo != null) {
            String[] items = this.combo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(this.defaultValue)) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void createWidgets(final UIComposite uiComposite) {
        this.label = new Label((Composite)uiComposite, 16384);
        this.label.setText((String)this.uiAttributes.get("label"));
        Composite comboComposite = new Composite((Composite)uiComposite, 0);
        comboComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        comboComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.combo = new Combo(comboComposite, 12);
        this.combo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.combo.setData(".uid", this.uiAttributes.get("id"));
        int index = 0;
        int defaultIndex = 0;
        for (String value : this.value2name.keySet()) {
            this.combo.add(this.value2name.get(value));
            if (value.equals(this.defaultValue)) {
                defaultIndex = index;
            }
            ++index;
        }
        this.combo.select(defaultIndex);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UISelectWidget.this.currentValue = UISelectWidget.this.getValue(UISelectWidget.this.combo.getItem(UISelectWidget.this.combo.getSelectionIndex()));
                uiComposite.firePatternEvent(UISelectWidget.this.createPatternEvent());
            }
        });
        uiComposite.firePatternEvent(this.createPatternEvent());
    }

    private PatternEvent createPatternEvent() {
        String msg = MessageFormat.format(Messages.getString("UISelectWidget_ErrorNoneSelected0"), this.label.getText());
        return new PatternEvent(this, msg, this.isValid());
    }

    @Override
    public boolean isValid() {
        boolean retVal = true;
        if (Boolean.parseBoolean((String)this.uiAttributes.get("mandatory")) && !"select".equals(this.uiAttributes.get("type"))) {
            retVal = this.currentValue != null && this.currentValue.trim().length() > 0;
        }
        return retVal;
    }

    private String getValue(String name) {
        for (String value : this.value2name.keySet()) {
            if (!this.value2name.get(value).equals(name)) continue;
            return value;
        }
        throw new IllegalStateException();
    }

    @Override
    public void disposeWidget() {
        this.label.dispose();
        this.combo.dispose();
    }
}

