/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.ui.preferences.CFileTypesPreferenceBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class CFileTypesPropertyPage
extends PropertyPage {
    protected Button fUseWorkspace;
    protected Button fUseProject;
    protected FixCFileTypesPreferenceBlock fPrefsBlock;

    public CFileTypesPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite topPane = new Composite(parent, 0);
        topPane.setLayout((Layout)new GridLayout());
        topPane.setLayoutData((Object)new GridData(1808));
        Composite radioPane = new Composite(topPane, 0);
        radioPane.setLayout((Layout)new GridLayout());
        radioPane.setLayoutData((Object)new GridData(768));
        this.fUseWorkspace = new Button(radioPane, 16);
        this.fUseWorkspace.setText(PreferencesMessages.CFileTypesPropertyPage_useWorkspaceSettings);
        this.fUseWorkspace.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (CFileTypesPropertyPage.this.fUseWorkspace.getSelection()) {
                    CFileTypesPropertyPage.this.fPrefsBlock.setInput(null);
                    CFileTypesPropertyPage.this.fPrefsBlock.setEnabled(false);
                }
            }
        });
        final IProject project = this.getProject();
        boolean custom = CCorePlugin.usesProjectSpecificContentTypes((IProject)project);
        this.fUseProject = new Button(radioPane, 16);
        this.fUseProject.setText(PreferencesMessages.CFileTypesPropertyPage_useProjectSettings);
        this.fUseProject.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (CFileTypesPropertyPage.this.fUseProject.getSelection()) {
                    CFileTypesPropertyPage.this.fPrefsBlock.setInput(project);
                    CFileTypesPropertyPage.this.fPrefsBlock.setEnabled(true);
                }
            }
        });
        Composite blockPane = new Composite(topPane, 0);
        blockPane.setLayout((Layout)new GridLayout());
        blockPane.setLayoutData((Object)new GridData(1808));
        this.fPrefsBlock = custom ? new FixCFileTypesPreferenceBlock(project) : new FixCFileTypesPreferenceBlock();
        this.fPrefsBlock.createControl(blockPane);
        this.fUseWorkspace.setSelection(!custom);
        this.fUseProject.setSelection(custom);
        this.fPrefsBlock.setEnabled(custom);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topPane, "org.eclipse.cdt.ui.std_prop_file_types");
        return topPane;
    }

    protected void performDefaults() {
        this.fUseWorkspace.setSelection(true);
        this.fUseProject.setSelection(false);
        this.fPrefsBlock.setInput(null);
        this.fPrefsBlock.setEnabled(false);
        super.performDefaults();
    }

    public boolean performOk() {
        boolean useProjectContentTypes = this.fUseProject.getSelection();
        IProject project = this.getProject();
        if (CCorePlugin.usesProjectSpecificContentTypes((IProject)project) != useProjectContentTypes) {
            CCorePlugin.setUseProjectSpecificContentTypes((IProject)project, (boolean)useProjectContentTypes);
            this.computeEvents(project);
        }
        if (useProjectContentTypes) {
            this.fPrefsBlock.performOk();
        }
        return super.performOk();
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        IProject project = null;
        if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof IAdaptable) {
            project = (IProject)element.getAdapter(IProject.class);
        }
        return project;
    }

    public IContentType[] getRegistedContentTypes() {
        String[] ids = CoreModel.getRegistedContentTypeIds();
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType[] ctypes = new IContentType[ids.length];
        int i = 0;
        while (i < ids.length) {
            ctypes[i] = manager.getContentType(ids[i]);
            ++i;
        }
        return ctypes;
    }

    void computeEvents(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IContentType[] ctypes = this.getRegistedContentTypes();
        ArrayList<IContentType> list = new ArrayList<IContentType>(ctypes.length);
        IContentType[] iContentTypeArray = ctypes;
        int n = ctypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ctype = iContentTypeArray[n2];
            try {
                IContentTypeSettings projectSettings = ctype.getSettings((IScopeContext)projectScope);
                String[] projectSpecs = projectSettings.getFileSpecs(8);
                if (projectSpecs != null && projectSpecs.length > 0) {
                    list.add(ctype);
                } else {
                    projectSpecs = projectSettings.getFileSpecs(4);
                    if (projectSpecs != null && projectSpecs.length > 0) {
                        list.add(ctype);
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        if (list.size() > 0) {
            IContentTypeManager.ContentTypeChangeEvent[] events = new IContentTypeManager.ContentTypeChangeEvent[list.size()];
            int i = 0;
            while (i < list.size()) {
                IContentType source = (IContentType)list.get(i);
                events[i] = new IContentTypeManager.ContentTypeChangeEvent(source, (IScopeContext)projectScope);
                ++i;
            }
            CModelManager.getDefault().contentTypeChanged(events);
        }
    }

    boolean isSpecsChanged(String[] newSpecs, String[] oldSpecs) {
        if (newSpecs.length != oldSpecs.length) {
            return true;
        }
        int i = 0;
        while (i < newSpecs.length) {
            String newSpec = newSpecs[i];
            boolean found = false;
            int j = 0;
            while (j < oldSpecs.length) {
                String oldSpec = oldSpecs[j];
                if (newSpec.equalsIgnoreCase(oldSpec)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class FixCFileTypesPreferenceBlock
    extends CFileTypesPreferenceBlock {
        ArrayList<IContentTypeManager.ContentTypeChangeEvent> list;

        public FixCFileTypesPreferenceBlock() {
            this.list = new ArrayList();
        }

        public FixCFileTypesPreferenceBlock(IProject input) {
            super(input);
            this.list = new ArrayList();
        }

        private IContentTypeManager.ContentTypeChangeEvent newContentTypeChangeEvent(IContentType source, IScopeContext context) {
            return new IContentTypeManager.ContentTypeChangeEvent(source, context);
        }

        @Override
        public boolean performOk() {
            int size;
            boolean changed = super.performOk();
            if (changed && (size = this.list.size()) > 0) {
                IContentTypeManager.ContentTypeChangeEvent[] events = new IContentTypeManager.ContentTypeChangeEvent[size];
                this.list.toArray(events);
                CModelManager.getDefault().contentTypeChanged(events);
            }
            return changed;
        }

        @Override
        protected void addAssociation(IScopeContext context, IContentType contentType, String spec, int type) {
            super.addAssociation(context, contentType, spec, type);
            this.list.add(this.newContentTypeChangeEvent(contentType, context));
        }

        @Override
        protected void removeAssociation(IScopeContext context, IContentType contentType, String spec, int type) {
            super.removeAssociation(context, contentType, spec, type);
            this.list.add(this.newContentTypeChangeEvent(contentType, context));
        }
    }
}

