/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.text.TMPresentationReconciler;
import org.eclipse.tm4e.ui.themes.ITheme;

public final class TMViewer
extends SourceViewer {
    private final TMPresentationReconciler reconciler = new TMPresentationReconciler();

    public TMViewer(Composite parent, int styles) {
        this(parent, null, null, false, styles);
    }

    public TMViewer(Composite parent, @Nullable IVerticalRuler verticalRuler, @Nullable IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.configure(new TMSourceViewerConfiguration());
    }

    public void setGrammar(@Nullable IGrammar grammar) {
        this.reconciler.setGrammar(grammar);
        if (this.getDocument() == null) {
            this.setDocument((IDocument)new Document());
        }
    }

    public void setTheme(ITheme theme) {
        this.reconciler.setTheme(theme);
        StyledText styledText = this.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setForeground(null);
        styledText.setBackground(null);
        theme.initializeViewerColors(styledText);
    }

    public void setText(String text) {
        if (this.getDocument() == null) {
            this.setDocument((IDocument)new Document());
        }
        ((IDocument)NullSafetyHelper.castNonNull((Object)this.getDocument())).set(text);
    }

    private final class TMSourceViewerConfiguration
    extends SourceViewerConfiguration {
        private TMSourceViewerConfiguration() {
        }

        public IPresentationReconciler getPresentationReconciler(@Nullable ISourceViewer sourceViewer) {
            return TMViewer.this.reconciler;
        }
    }
}

