/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceUnmarshaller;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ServiceHelper;

public class RemoteMarketplaceService<T> {
    protected URL baseUrl;
    public static final String API_URI_SUFFIX = "api/p";
    private static final int RETRY_COUNT = 3;
    protected final ITransport transport = TransportFactory.createTransport();
    protected final IMarketplaceUnmarshaller unmarshaller;
    private Map<String, String> requestMetaParameters;

    public RemoteMarketplaceService() {
        IMarketplaceUnmarshaller unmarshaller = ServiceHelper.getMarketplaceUnmarshaller();
        if (unmarshaller == null) {
            unmarshaller = new MarketplaceUnmarshaller();
        }
        this.unmarshaller = unmarshaller;
    }

    protected IStatus createErrorStatus(String message, Throwable t) {
        return this.createStatus(4, message, t);
    }

    protected IStatus createErrorStatus(String messageTemplate, Object ... parameters) {
        return this.createStatus(4, messageTemplate, parameters);
    }

    protected IStatus createStatus(int severity, String message, Throwable t) {
        return new Status(severity, "org.eclipse.epp.mpc.core", 0, message, t);
    }

    protected IStatus createStatus(int severity, String messageTemplate, Object ... parameters) {
        String message = messageTemplate;
        Throwable exception = null;
        if (parameters != null && parameters.length > 0) {
            message = messageTemplate == null ? null : MessageFormat.format(messageTemplate, parameters);
            exception = RemoteMarketplaceService.findException(parameters);
        }
        return this.createStatus(severity, message, exception);
    }

    private static Throwable findException(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        int i = parameters.length - 1;
        while (i >= 0) {
            if (parameters[i] instanceof Throwable) {
                return (Throwable)parameters[i];
            }
            --i;
        }
        return null;
    }

    private void checkConfiguration() {
        if (this.baseUrl == null) {
            throw new IllegalStateException(Messages.DefaultMarketplaceService_mustConfigureBaseUrl);
        }
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected T processRequest(String relativeUrl, IProgressMonitor monitor) throws CoreException {
        return this.processRequest(relativeUrl, true, monitor);
    }

    protected T processRequest(String relativeUrl, boolean withMetaParams, IProgressMonitor monitor) throws CoreException {
        URI baseUri;
        try {
            baseUri = this.baseUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return this.processRequest(baseUri.toString(), relativeUrl, withMetaParams, monitor);
    }

    protected T processRequest(String baseUri, String relativePath, IProgressMonitor monitor) throws CoreException {
        return this.processRequest(baseUri, relativePath, true, monitor);
    }

    /*
     * Exception decompiling
     */
    protected T processRequest(String baseUri, String relativePath, boolean withMetaParams, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String addMetaParameters(String uri) {
        if (this.requestMetaParameters != null) {
            boolean hasQueryString = ((String)uri).indexOf(63) != -1;
            for (Map.Entry<String, String> param : this.requestMetaParameters.entrySet()) {
                if (param.getKey() == null) continue;
                if (hasQueryString) {
                    uri = (String)uri + "&";
                } else {
                    hasQueryString = true;
                    uri = (String)uri + "?";
                }
                uri = (String)uri + URLEncoder.encode(param.getKey(), StandardCharsets.UTF_8);
                uri = (String)uri + "=";
                if (param.getValue() == null) continue;
                uri = (String)uri + URLEncoder.encode(param.getValue(), StandardCharsets.UTF_8);
            }
        }
        return uri;
    }

    public Map<String, String> getRequestMetaParameters() {
        return this.requestMetaParameters;
    }

    public void setRequestMetaParameters(Map<String, String> requestMetaParameters) {
        this.requestMetaParameters = requestMetaParameters;
    }

    protected static String urlEncode(String urlPart) {
        return URLEncoder.encode(urlPart, StandardCharsets.UTF_8);
    }

    public void activate(Map<?, ?> properties) {
        URL url;
        if (properties != null && (url = ServiceUtil.getUrl(properties, "url", null)) != null) {
            this.setBaseUrl(url);
        }
    }
}

