/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.search.CommitSearchResult;
import org.eclipse.egit.ui.internal.search.CommitSearchSettings;
import org.eclipse.egit.ui.internal.search.PatternUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class CommitSearchQuery
implements ISearchQuery {
    private CommitSearchResult result = new CommitSearchResult(this);
    private CommitSearchSettings settings;
    private List<SearchMatcher> matchers = new LinkedList<SearchMatcher>();

    public CommitSearchQuery(CommitSearchSettings settings) {
        this.settings = settings;
        if (this.settings.isMatchAuthor()) {
            this.matchers.add(new AuthorMatcher());
        }
        if (this.settings.isMatchCommitter()) {
            this.matchers.add(new CommitterMatcher());
        }
        if (this.settings.isMatchMessage()) {
            this.matchers.add(new MessageMatcher());
        }
        if (this.settings.isMatchCommit()) {
            this.matchers.add(new CommitNameMatcher());
        }
        if (this.settings.isMatchTree()) {
            this.matchers.add(new TreeMatcher());
        }
        if (this.settings.isMatchParents()) {
            this.matchers.add(new ParentMatcher());
        }
    }

    public String getPattern() {
        return this.settings.getTextPattern();
    }

    private Repository getRepository(String name) throws IOException {
        Repository repository = null;
        File path = new File(name);
        if (path.exists()) {
            repository = RepositoryCache.INSTANCE.lookupRepository(path);
        }
        return repository;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.result.removeAll();
        Pattern pattern = PatternUtils.createPattern(this.settings.getTextPattern(), this.settings.isCaseSensitive(), this.settings.isRegExSearch());
        List<String> paths = this.settings.getRepositories();
        try {
            for (String path : paths) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Repository repo = this.getRepository(path);
                if (repo == null) continue;
                monitor.setTaskName(MessageFormat.format(UIText.CommitSearchQuery_TaskSearchCommits, repo.getDirectory().getParentFile().getName()));
                this.walkRepository(repo, pattern, monitor);
            }
        }
        catch (IOException e) {
            Activator.handleError("Error searching commits", e, true);
        }
        return Status.OK_STATUS;
    }

    private void walkRepository(Repository repository, Pattern pattern, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (RevWalk walk = new RevWalk(repository);){
            walk.setRetainBody(true);
            LinkedList<RevCommit> commits = new LinkedList<RevCommit>();
            if (this.settings.isAllBranches()) {
                for (Ref ref : repository.getRefDatabase().getRefsByPrefix("refs/heads/")) {
                    if (ref.isSymbolic()) continue;
                    commits.add(walk.parseCommit((AnyObjectId)ref.getObjectId()));
                }
                for (Ref ref : repository.getRefDatabase().getRefsByPrefix("refs/remotes/")) {
                    if (ref.isSymbolic()) continue;
                    commits.add(walk.parseCommit((AnyObjectId)ref.getObjectId()));
                }
            } else {
                ObjectId headCommit = repository.resolve("HEAD");
                if (headCommit != null) {
                    commits.add(walk.parseCommit((AnyObjectId)headCommit));
                }
            }
            if (!commits.isEmpty()) {
                walk.markStart(commits);
                block7: for (RevCommit commit : walk) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (SearchMatcher matcher : this.matchers) {
                        if (!matcher.matches(pattern, commit)) continue;
                        this.result.addResult(new RepositoryCommit(repository, commit));
                        continue block7;
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getLabel() {
        return UIText.CommitSearchQuery_Label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    private class AuthorMatcher
    extends SearchMatcher {
        private AuthorMatcher() {
        }

        @Override
        public boolean matches(Pattern pattern, RevCommit commit) {
            PersonIdent author = commit.getAuthorIdent();
            if (author != null) {
                return this.matches(pattern, author.getName()) || this.matches(pattern, author.getEmailAddress());
            }
            return false;
        }
    }

    private class CommitNameMatcher
    extends SearchMatcher {
        private CommitNameMatcher() {
        }

        @Override
        public boolean matches(Pattern pattern, RevCommit commit) {
            return this.matches(pattern, commit.name());
        }
    }

    private class CommitterMatcher
    extends SearchMatcher {
        private CommitterMatcher() {
        }

        @Override
        public boolean matches(Pattern pattern, RevCommit commit) {
            PersonIdent committer = commit.getCommitterIdent();
            if (committer != null) {
                return this.matches(pattern, committer.getName()) || this.matches(pattern, committer.getEmailAddress());
            }
            return false;
        }
    }

    private class MessageMatcher
    extends SearchMatcher {
        private MessageMatcher() {
        }

        @Override
        public boolean matches(Pattern pattern, RevCommit commit) {
            return this.matches(pattern, commit.getFullMessage());
        }
    }

    private class ParentMatcher
    extends SearchMatcher {
        private ParentMatcher() {
        }

        @Override
        public boolean matches(Pattern pattern, RevCommit commit) {
            RevCommit[] revCommitArray = commit.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit parent = revCommitArray[n2];
                if (this.matches(pattern, parent.name())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static abstract class SearchMatcher {
        private SearchMatcher() {
        }

        abstract boolean matches(Pattern var1, RevCommit var2);

        protected boolean matches(Pattern pattern, String input) {
            return input != null && input.length() > 0 && pattern.matcher(input).find();
        }
    }

    private class TreeMatcher
    extends SearchMatcher {
        private TreeMatcher() {
        }

        @Override
        public boolean matches(Pattern pattern, RevCommit commit) {
            RevTree tree = commit.getTree();
            return tree != null ? this.matches(pattern, tree.name()) : false;
        }
    }
}

