/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;

public class BinaryFileOutputStream
extends ByteArrayOutputStream {
    protected final IFile _file;
    private final BuildEnv _env;

    public BinaryFileOutputStream(IFile file, BuildEnv env) {
        this._file = file;
        this._env = env;
    }

    @Override
    public void close() throws IOException {
        IFile parentFile;
        super.close();
        byte[] newContent = this.toByteArray();
        boolean contentsChanged = true;
        try {
            byte[] oldContent = this._file.readAllBytes();
            if (Arrays.equals(newContent, oldContent)) {
                contentsChanged = false;
            }
        }
        catch (CoreException ce) {
            contentsChanged = true;
        }
        if (contentsChanged) {
            FileSystemUtil.saveToDisk(this._file, newContent);
        }
        if ((parentFile = this._env.getFile()) != null) {
            this._env.getAptProject().getGeneratedFileManager(this._env.isTestCode()).addGeneratedFileDependency(Collections.singleton(parentFile), this._file);
            this._env.addGeneratedNonSourceFile(this._file);
        }
    }
}

