/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupParticipant;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;

public class CSourceLookupDirector
extends AbstractSourceLookupDirector {
    private static Set<String> fSupportedTypes;
    private static Object fSupportedTypesLock;

    static {
        fSupportedTypesLock = new Object();
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new CSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        this.readSupportedContainerTypes();
        return fSupportedTypes.contains(type.getId());
    }

    public IPath getCompilationPath(String sourceName) {
        ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            IPath path = SourceUtils.getCompilationPath(container, sourceName);
            if (path != null) {
                return path;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSupportedContainerTypes() {
        Object object = fSupportedTypesLock;
        synchronized (object) {
            if (fSupportedTypes == null) {
                fSupportedTypes = new HashSet<String>();
                String name = "org.eclipse.cdt.debug.core.supportedSourceContainerTypes";
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(name);
                if (extensionPoint != null) {
                    IExtension[] iExtensionArray = extensionPoint.getExtensions();
                    int n = iExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement configurationElements = iConfigurationElementArray[n4];
                            String id = configurationElements.getAttribute("id");
                            if (id != null) {
                                fSupportedTypes.add(id);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

