/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.io.CancellableDigestOutputStream;
import org.eclipse.jgit.internal.storage.midx.PackIndexMerger;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.NB;

public class MultiPackIndexWriter {
    private static final int LIMIT_31_BITS = Integer.MAX_VALUE;
    private static final int MIDX_HEADER_SIZE = 12;

    public Result write(ProgressMonitor monitor, OutputStream outputStream, Map<String, PackIndex> inputs) throws IOException {
        PackIndexMerger data = new PackIndexMerger(inputs);
        List<ChunkHeader> chunkHeaders = this.createChunkHeaders(data);
        long expectedSize = MultiPackIndexWriter.calculateExpectedSize(chunkHeaders);
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (CancellableDigestOutputStream out = new CancellableDigestOutputStream(monitor, outputStream);){
                this.writeHeader(out, chunkHeaders.size(), data.getPackCount());
                this.writeChunkLookup(out, chunkHeaders);
                WriteContext ctx = new WriteContext(out, data);
                for (ChunkHeader chunk : chunkHeaders) {
                    chunk.writerFn.write(ctx);
                }
                this.writeCheckSum(out);
                if (expectedSize != out.length()) {
                    throw new IllegalStateException(String.format(JGitText.get().multiPackIndexUnexpectedSize, expectedSize, out.length()));
                }
                return new Result(expectedSize, data.getUniqueObjectCount(), data.getPackNames());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedIOException e) {
            throw new IOException(JGitText.get().multiPackIndexWritingCancelled, e);
        }
    }

    private static long calculateExpectedSize(List<ChunkHeader> chunks) {
        int chunkLookup = (chunks.size() + 1) * 12;
        long chunkContent = chunks.stream().mapToLong(c -> c.size).sum();
        return (long)(12 + chunkLookup) + chunkContent + 20L;
    }

    private List<ChunkHeader> createChunkHeaders(PackIndexMerger data) {
        ArrayList<ChunkHeader> chunkHeaders = new ArrayList<ChunkHeader>();
        chunkHeaders.add(new ChunkHeader(1330201670, 1024L, this::writeFanoutTable));
        chunkHeaders.add(new ChunkHeader(1330201676, (long)data.getUniqueObjectCount() * 20L, this::writeOidLookUp));
        chunkHeaders.add(new ChunkHeader(0x4F4F4646, 8L * (long)data.getUniqueObjectCount(), this::writeObjectOffsets));
        if (data.needsLargeOffsetsChunk()) {
            chunkHeaders.add(new ChunkHeader(1280263750, 8L * (long)data.getOffsetsOver31BitsCount(), this::writeObjectLargeOffsets));
        }
        chunkHeaders.add(new ChunkHeader(1380533336, 4L * (long)data.getUniqueObjectCount(), this::writeRidx));
        chunkHeaders.add(new ChunkHeader(1112821072, 8L * (long)data.getPackCount(), this::writeBitmappedPackfiles));
        int packNamesSize = data.getPackNames().stream().mapToInt(String::length).map(i -> i + 1).sum();
        chunkHeaders.add(new ChunkHeader(1347305805, packNamesSize, this::writePackfileNames));
        return chunkHeaders;
    }

    private void writeHeader(CancellableDigestOutputStream out, int numChunks, int packCount) throws IOException {
        byte[] headerBuffer = new byte[12];
        NB.encodeInt32(headerBuffer, 0, 1296647256);
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = (byte)numChunks;
        byte[] buff = byArray;
        System.arraycopy(buff, 0, headerBuffer, 4, 4);
        NB.encodeInt32(headerBuffer, 8, packCount);
        out.write(headerBuffer, 0, headerBuffer.length);
        out.flush();
    }

    private void writeChunkLookup(CancellableDigestOutputStream out, List<ChunkHeader> chunkHeaders) throws IOException {
        long chunkStart = 12L + (long)(chunkHeaders.size() + 1) * 12L;
        byte[] chunkEntry = new byte[12];
        for (ChunkHeader chunkHeader : chunkHeaders) {
            NB.encodeInt32(chunkEntry, 0, chunkHeader.chunkId);
            NB.encodeInt64(chunkEntry, 4, chunkStart);
            out.write(chunkEntry);
            chunkStart += chunkHeader.size;
        }
        NB.encodeInt32(chunkEntry, 0, 0);
        NB.encodeInt64(chunkEntry, 4, chunkStart);
        out.write(chunkEntry);
    }

    private void writeFanoutTable(WriteContext ctx) throws IOException {
        byte[] tmp = new byte[4];
        int[] fanout = new int[256];
        Iterator<PackIndexMerger.MidxMutableEntry> iterator = ctx.data.bySha1Iterator();
        while (iterator.hasNext()) {
            PackIndexMerger.MidxMutableEntry e = iterator.next();
            int n = e.getObjectId().getFirstByte() & 0xFF;
            fanout[n] = fanout[n] + 1;
        }
        int i = 1;
        while (i < fanout.length) {
            int n = i;
            fanout[n] = fanout[n] + fanout[i - 1];
            ++i;
        }
        int[] nArray = fanout;
        int n = fanout.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            NB.encodeInt32(tmp, 0, n3);
            ctx.out.write(tmp, 0, 4);
            ++n2;
        }
    }

    private void writeOidLookUp(WriteContext ctx) throws IOException {
        byte[] tmp = new byte[20];
        Iterator<PackIndexMerger.MidxMutableEntry> iterator = ctx.data.bySha1Iterator();
        while (iterator.hasNext()) {
            PackIndexMerger.MidxMutableEntry e = iterator.next();
            e.getObjectId().copyRawTo(tmp, 0);
            ctx.out.write(tmp, 0, 20);
        }
    }

    private void writeObjectOffsets(WriteContext ctx) throws IOException {
        byte[] entry = new byte[8];
        Iterator<PackIndexMerger.MidxMutableEntry> iterator = ctx.data.bySha1Iterator();
        while (iterator.hasNext()) {
            PackIndexMerger.MidxMutableEntry e = iterator.next();
            NB.encodeInt32(entry, 0, e.getPackId());
            if (!ctx.data.needsLargeOffsetsChunk() || MultiPackIndexWriter.fitsIn31bits(e.getOffset())) {
                NB.encodeInt32(entry, 4, (int)e.getOffset());
            } else {
                int offloadedPosition = ctx.largeOffsets.append(e.getOffset());
                NB.encodeInt32(entry, 4, offloadedPosition | Integer.MIN_VALUE);
            }
            ctx.out.write(entry);
        }
    }

    private void writeRidx(WriteContext ctx) throws IOException {
        HashMap<Integer, List> packOffsets = new HashMap<Integer, List>(ctx.data.getPackCount());
        Iterator<PackIndexMerger.MidxMutableEntry> iterator = ctx.data.bySha1Iterator();
        int midxPosition = 0;
        while (iterator.hasNext()) {
            PackIndexMerger.MidxMutableEntry e = iterator.next();
            OffsetPosition op = new OffsetPosition(e.getOffset(), midxPosition);
            ++midxPosition;
            packOffsets.computeIfAbsent(e.getPackId(), k -> new ArrayList()).add(op);
        }
        int i = 0;
        while (i < ctx.data.getPackCount()) {
            List offsetsForPack = (List)packOffsets.get(i);
            if (offsetsForPack != null) {
                offsetsForPack.sort(Comparator.comparing(OffsetPosition::offset));
                byte[] ridxForPack = new byte[4 * offsetsForPack.size()];
                int j = 0;
                while (j < offsetsForPack.size()) {
                    NB.encodeInt32(ridxForPack, j * 4, ((OffsetPosition)offsetsForPack.get((int)j)).position);
                    ++j;
                }
                ctx.out.write(ridxForPack);
            }
            ++i;
        }
    }

    private void writeBitmappedPackfiles(WriteContext ctx) throws IOException {
        int[] objsPerPack = ctx.data.getObjectsPerPack();
        byte[] buffer = new byte[8 * objsPerPack.length];
        int bufferPos = 0;
        int accruedBitmapPositions = 0;
        int pack = 0;
        while (pack < objsPerPack.length) {
            NB.encodeInt32(buffer, bufferPos, accruedBitmapPositions);
            NB.encodeInt32(buffer, bufferPos + 4, objsPerPack[pack]);
            accruedBitmapPositions += objsPerPack[pack];
            bufferPos += 8;
            ++pack;
        }
        ctx.out.write(buffer);
    }

    private void writeObjectLargeOffsets(WriteContext ctx) throws IOException {
        ctx.out.write(ctx.largeOffsets.offsets, 0, ctx.largeOffsets.bytePosition);
    }

    private void writePackfileNames(WriteContext ctx) throws IOException {
        for (String packName : ctx.data.getPackNames()) {
            ctx.out.write(packName.getBytes(StandardCharsets.UTF_8));
            ctx.out.write(0);
        }
    }

    private void writeCheckSum(CancellableDigestOutputStream out) throws IOException {
        out.write(out.getDigest());
        out.flush();
    }

    private static boolean fitsIn31bits(long offset) {
        return offset <= Integer.MAX_VALUE;
    }

    private record ChunkHeader(int chunkId, long size, ChunkWriter writerFn) {
    }

    @FunctionalInterface
    private static interface ChunkWriter {
        public void write(WriteContext var1) throws IOException;
    }

    private static class LargeOffsets {
        private final byte[] offsets;
        private int bytePosition;

        LargeOffsets(int largeOffsetsCount) {
            this.offsets = new byte[largeOffsetsCount * 8];
            this.bytePosition = 0;
        }

        int append(long largeOffset) {
            int at = this.bytePosition;
            NB.encodeInt64(this.offsets, at, largeOffset);
            this.bytePosition += 8;
            return at / 8;
        }
    }

    private record OffsetPosition(long offset, int position) {
    }

    public record Result(long bytesWritten, int objectCount, List<String> packNames) {
    }

    private static class WriteContext {
        final CancellableDigestOutputStream out;
        final PackIndexMerger data;
        final LargeOffsets largeOffsets;

        WriteContext(CancellableDigestOutputStream out, PackIndexMerger data) {
            this.out = out;
            this.data = data;
            this.largeOffsets = new LargeOffsets(data.getOffsetsOver31BitsCount());
        }
    }
}

