/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CHelpBookDescriptor {
    private static final String ELEMENT_BOOK = "book";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private boolean fEnabled = true;
    private ICHelpBook fCHelpBook;

    CHelpBookDescriptor(ICHelpBook book) {
        this(book, null);
    }

    CHelpBookDescriptor(ICHelpBook book, Element parentElement) {
        this.fCHelpBook = book;
        if (parentElement == null) {
            return;
        }
        NodeList bookElements = parentElement.getElementsByTagName(ELEMENT_BOOK);
        if (bookElements.getLength() == 0) {
            return;
        }
        String title = book.getTitle();
        int i = 0;
        while (i < bookElements.getLength()) {
            Element bookElement = (Element)bookElements.item(i);
            if (title.equals(bookElement.getAttribute(ATTRIBUTE_TITLE))) {
                this.fEnabled = VALUE_TRUE.equalsIgnoreCase(bookElement.getAttribute(ATTRIBUTE_ENABLED));
                break;
            }
            ++i;
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean matches(ICHelpInvocationContext context) {
        ITranslationUnit unit = context.getTranslationUnit();
        if (unit != null) {
            return this.matches(unit);
        }
        IProject project = context.getProject();
        if (project != null) {
            return this.matches(project);
        }
        return true;
    }

    public boolean matches(IProject project) {
        ICHelpBook book = this.getCHelpBook();
        boolean bMatches = false;
        switch (book.getCHelpType()) {
            case 2: {
                try {
                    bMatches = project.hasNature("org.eclipse.cdt.core.ccnature");
                }
                catch (CoreException coreException) {}
                break;
            }
            case 1: 
            case 3: {
                try {
                    bMatches = project.hasNature("org.eclipse.cdt.core.cnature");
                }
                catch (CoreException coreException) {}
                break;
            }
            default: {
                bMatches = true;
            }
        }
        return bMatches;
    }

    public boolean matches(ITranslationUnit unit) {
        ICHelpBook book = this.getCHelpBook();
        boolean bMatches = false;
        switch (book.getCHelpType()) {
            case 2: {
                bMatches = unit.isCXXLanguage();
                break;
            }
            case 1: {
                bMatches = unit.isCLanguage() || unit.isCXXLanguage();
                break;
            }
            case 3: {
                bMatches = unit.isASMLanguage();
                break;
            }
            default: {
                bMatches = true;
            }
        }
        return bMatches;
    }

    public void enable(boolean enable) {
        this.fEnabled = enable;
    }

    public ICHelpBook getCHelpBook() {
        return this.fCHelpBook;
    }

    public void serialize(Document doc, Element parentElement) {
        Element bookElement = doc.createElement(ELEMENT_BOOK);
        bookElement.setAttribute(ATTRIBUTE_TITLE, this.getCHelpBook().getTitle());
        bookElement.setAttribute(ATTRIBUTE_ENABLED, this.fEnabled ? VALUE_TRUE : VALUE_FALSE);
        parentElement.appendChild(bookElement);
    }
}

