/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.ClangToolChain;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.Homebrew;
import org.eclipse.core.runtime.Platform;

public class HomebrewToolChainProvider
implements IToolChainProvider {
    private static final String ID = "org.eclipse.cdt.build.gcc.core.homebrewProvider";
    private static final Pattern CLANG_PATTERN = Pattern.compile("clang-\\d+");
    private static final Pattern GCC_PATTERN = Pattern.compile("gcc-\\d+");
    private static final String ENV_PATH = "PATH";
    private static final String HOMEBREW_PACKAGE = "homebrew";

    public String getId() {
        return ID;
    }

    public void init(IToolChainManager manager) {
        String homebrewHome = Homebrew.getHomebrewHome();
        if (homebrewHome != null) {
            GCCToolChain toolChain;
            IEnvironmentVariable[] vars;
            Path homebrewPath = new File(homebrewHome).toPath();
            Path homebrewBinPath = homebrewPath.resolve("bin");
            Path homebrewLlvmBinPath = homebrewPath.resolve("opt/llvm/bin");
            File[] fileArray = this.getFiles(homebrewLlvmBinPath, CLANG_PATTERN);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File clangFile = fileArray[n2];
                vars = this.createEnvironmentVariables(homebrewLlvmBinPath);
                toolChain = new ClangToolChain((IToolChainProvider)this, clangFile.toPath(), Platform.getOSArch(), vars);
                toolChain.setProperty("package", HOMEBREW_PACKAGE);
                manager.addToolChain((IToolChain)toolChain);
                ++n2;
            }
            fileArray = this.getFiles(homebrewBinPath, GCC_PATTERN);
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                File gccFile = fileArray[n2];
                vars = this.createEnvironmentVariables(homebrewBinPath);
                toolChain = new GCCToolChain((IToolChainProvider)this, gccFile.toPath(), Platform.getOSArch(), vars);
                toolChain.setProperty("package", HOMEBREW_PACKAGE);
                manager.addToolChain((IToolChain)toolChain);
                ++n2;
            }
        }
    }

    private File[] getFiles(Path path, Pattern filePattern) {
        File dir = path.toFile();
        if (dir.isDirectory()) {
            return dir.listFiles(file -> file.isFile() && filePattern.matcher(file.getName()).matches());
        }
        return new File[0];
    }

    private IEnvironmentVariable[] createEnvironmentVariables(Path path) {
        EnvironmentVariable pathVariable = new EnvironmentVariable(ENV_PATH, path.toString(), 3, File.pathSeparator);
        return new IEnvironmentVariable[]{pathVariable};
    }
}

