/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.PseudoNameGenerator;

public class ParameterHandler {
    private boolean needsAditionalArgumentNames;
    private PseudoNameGenerator pseudoNameGenerator;
    private ArrayList<ParameterInfo> parameterInfos;
    private IASTSimpleDeclaration method;

    public ParameterHandler(IASTSimpleDeclaration method) {
        this.method = method;
        this.initArgumentNames();
    }

    public boolean needsAdditionalArgumentNames() {
        return this.needsAditionalArgumentNames;
    }

    public void initArgumentNames() {
        if (this.parameterInfos != null) {
            return;
        }
        this.needsAditionalArgumentNames = false;
        this.parameterInfos = new ArrayList();
        IASTParameterDeclaration[] iASTParameterDeclarationArray = this.getParametersFromMethodNode();
        int n = iASTParameterDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTParameterDeclaration actParam = iASTParameterDeclarationArray[n2];
            String actName = actParam.getDeclarator().getName().toString();
            boolean isChangable = false;
            if (actParam.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)actParam.getDeclSpecifier()).getType() == 1) {
                actName = "";
                isChangable = false;
            } else if (actName.length() == 0) {
                this.needsAditionalArgumentNames = true;
                isChangable = true;
                actName = this.findNameForParameter(NameHelper.getTypeName(actParam));
            }
            this.parameterInfos.add(new ParameterInfo(actParam, actName, isChangable));
            ++n2;
        }
    }

    private String findNameForParameter(String typeName) {
        if (this.pseudoNameGenerator == null) {
            this.pseudoNameGenerator = new PseudoNameGenerator();
            IASTParameterDeclaration[] iASTParameterDeclarationArray = this.getParametersFromMethodNode();
            int n = iASTParameterDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTParameterDeclaration parameter = iASTParameterDeclarationArray[n2];
                if (parameter.getDeclarator().getName().toString().length() != 0) {
                    this.pseudoNameGenerator.addExistingName(parameter.getDeclarator().getName().toString());
                }
                ++n2;
            }
        }
        return this.pseudoNameGenerator.generateNewName(typeName);
    }

    private IASTParameterDeclaration[] getParametersFromMethodNode() {
        if (this.method.getDeclarators().length < 1) {
            return null;
        }
        return ((ICPPASTFunctionDeclarator)this.method.getDeclarators()[0]).getParameters();
    }

    public Collection<ParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }
}

