/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.cmake.core.properties.ICMakeGenerator;
import org.eclipse.cdt.cmake.core.properties.ICMakeProperties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class CommandDescriptorBuilder {
    private final ICMakeProperties cmakeProperties;

    public CommandDescriptorBuilder(ICMakeProperties cmakeProperties) {
        this.cmakeProperties = Objects.requireNonNull(cmakeProperties);
    }

    public CommandDescriptor makeCMakeCommandline(Path toolChainFile) throws CoreException {
        String bt;
        String file;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        args.add(varManager.performStringSubstitution(this.cmakeProperties.getCommand()));
        if (this.cmakeProperties.isWarnNoDev()) {
            args.add("-Wno-dev");
        }
        if (this.cmakeProperties.isDebugTryCompile()) {
            args.add("--debug-trycompile");
        }
        if (this.cmakeProperties.isDebugOutput()) {
            args.add("--debug-output");
        }
        if (this.cmakeProperties.isTrace()) {
            args.add("--trace");
        }
        if (this.cmakeProperties.isWarnUninitialized()) {
            args.add("--warn-uninitialized");
        }
        if (this.cmakeProperties.isWarnUnusedVars()) {
            args.add("--warn-unused-vars");
        }
        if ((file = this.cmakeProperties.getCacheFile()) != null && !file.isBlank()) {
            args.add("-C");
            args.add(file);
        }
        if ((bt = this.cmakeProperties.getBuildType()) != null && !bt.isBlank()) {
            args.add("-DCMAKE_BUILD_TYPE=" + bt);
        }
        args.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
        if (toolChainFile != null) {
            args.add("-DCMAKE_TOOLCHAIN_FILE=" + toolChainFile.toString());
        }
        args.add("-G");
        ICMakeGenerator generator = this.cmakeProperties.getGenerator();
        args.add(generator.getCMakeName());
        CommandDescriptorBuilder.appendCMakeArguments(args, this.cmakeProperties.getExtraArguments());
        return new CommandDescriptor(args, env);
    }

    public CommandDescriptor makeCMakeBuildCommandline(String buildscriptTarget) throws CoreException {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        String cmd = varManager.performStringSubstitution(this.cmakeProperties.getCommand());
        args.add(cmd);
        args.add("--build");
        args.add(".");
        args.add("--target");
        args.add(buildscriptTarget);
        return new CommandDescriptor(args, env);
    }

    private static void appendCMakeArguments(List<String> argList, List<String> moreArgs) throws CoreException {
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        for (String arg : moreArgs) {
            String expanded = mgr.performStringSubstitution(arg);
            argList.add(expanded);
        }
    }

    public static final class CommandDescriptor {
        private final List<String> arguments;
        private final List<String> environment;

        CommandDescriptor(List<String> arguments, List<String> environment) {
            this.arguments = Objects.requireNonNull(arguments);
            this.environment = Objects.requireNonNull(environment);
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public List<String> getEnvironment() {
            return this.environment;
        }
    }
}

