/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetListener;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeTargetEvent;
import org.eclipse.cdt.make.internal.core.ListenerList;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.ProjectTargets;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class MakeTargetManager
implements IMakeTargetManager,
IResourceChangeListener {
    private static String TARGET_BUILD_EXT = "MakeTargetBuilder";
    private static String TARGETS_EXT = "targets";
    private final ListenerList listeners = new ListenerList();
    private final Map<IProject, ProjectTargets> projectMap = new HashMap<IProject, ProjectTargets>();
    private HashMap<String, String> builderMap;
    protected Vector<IProject> fProjects = new Vector();

    @Override
    public IMakeTarget createTarget(IProject project, String name, String targetBuilderID) throws CoreException {
        return new MakeTarget(this, project, targetBuilderID, name);
    }

    @Override
    public void addTarget(IMakeTarget target) throws CoreException {
        this.addTarget(null, target);
    }

    @Override
    public void addTarget(IContainer container, IMakeTarget target) throws CoreException {
        if (container instanceof IWorkspaceRoot) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.add_to_workspace_root"), null));
        }
        ProjectTargets projectTargets = this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        target.setContainer((IContainer)(container == null ? target.getProject() : container));
        projectTargets.add(target);
        try {
            this.writeTargets(projectTargets);
        }
        catch (CoreException e) {
            projectTargets.remove(target);
            throw e;
        }
        this.notifyListeners(new MakeTargetEvent((Object)this, 1, target));
    }

    @Override
    public void setTargets(IContainer container, IMakeTarget[] targets) throws CoreException {
        if (container instanceof IWorkspaceRoot) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.add_to_workspace_root"), null));
        }
        ProjectTargets projectTargets = this.projectMap.get(targets[0].getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(targets[0].getProject());
        }
        if (container == null) {
            container = targets[0].getProject();
        }
        IMakeTarget[] oldTargets = projectTargets.get(container);
        projectTargets.set(container, targets);
        try {
            this.writeTargets(projectTargets);
        }
        catch (CoreException e) {
            projectTargets.set(container, oldTargets);
            throw e;
        }
        this.notifyListeners(new MakeTargetEvent((Object)this, 1, targets[0]));
    }

    @Override
    public boolean targetExists(IMakeTarget target) {
        ProjectTargets projectTargets = this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        return projectTargets.contains(target);
    }

    @Override
    public void removeTarget(IMakeTarget target) throws CoreException {
        ProjectTargets projectTargets = this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        if (projectTargets.remove(target)) {
            try {
                this.writeTargets(projectTargets);
            }
            catch (CoreException e) {
                projectTargets.add(target);
                throw e;
            }
            this.notifyListeners(new MakeTargetEvent((Object)this, 3, target));
        }
    }

    @Override
    public void renameTarget(IMakeTarget target, String name) throws CoreException {
        IMakeTarget makeTarget = target;
        ProjectTargets projectTargets = this.projectMap.get(makeTarget.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(makeTarget.getProject());
        }
        makeTarget.setName(name);
        if (projectTargets.contains(makeTarget)) {
            this.updateTarget(makeTarget);
        }
    }

    @Override
    public IMakeTarget[] getTargets(IContainer container) throws CoreException {
        ProjectTargets projectTargets = this.projectMap.get(container.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(container.getProject());
        }
        return projectTargets.get(container);
    }

    @Override
    public IMakeTarget findTarget(IContainer container, String name) throws CoreException {
        ProjectTargets projectTargets = this.projectMap.get(container.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(container.getProject());
        }
        return projectTargets.findTarget(container, name);
    }

    @Override
    public IProject[] getTargetBuilderProjects() {
        return this.fProjects.toArray(new IProject[this.fProjects.size()]);
    }

    @Override
    public String[] getTargetBuilders(IProject project) {
        if (this.fProjects.contains(project) || this.hasTargetBuilder(project)) {
            try {
                ICommand[] commands;
                Vector<String> ids = new Vector<String>();
                IProjectDescription description = project.getDescription();
                ICommand[] iCommandArray = commands = description.getBuildSpec();
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    for (Map.Entry<String, String> entry : this.builderMap.entrySet()) {
                        if (!entry.getValue().equals(command.getBuilderName())) continue;
                        ids.add(entry.getKey());
                    }
                    ++n2;
                }
                return ids.toArray(new String[ids.size()]);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasTargetBuilder(IProject project) {
        try {
            ICommand[] commands;
            if (!project.isAccessible()) return false;
            IProjectDescription description = project.getDescription();
            ICommand[] iCommandArray = commands = description.getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand command = iCommandArray[n2];
                if (this.builderMap.containsValue(command.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public void startup() {
        IProject[] projects;
        this.initializeBuilders();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.hasTargetBuilder(project)) {
                this.fProjects.add(project);
            }
            ++n2;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)new MakeTargetVisitor());
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }
    }

    protected void updateTarget(IMakeTarget target) throws CoreException {
        if (target.getContainer() != null) {
            ProjectTargets projectTargets = this.projectMap.get(target.getProject());
            if (projectTargets == null || !projectTargets.contains(target)) {
                return;
            }
            this.writeTargets(projectTargets);
            this.notifyListeners(new MakeTargetEvent((Object)this, 2, target));
        }
    }

    protected void writeTargets(ProjectTargets projectTargets) throws CoreException {
        projectTargets.saveTargets();
    }

    protected ProjectTargets readTargets(IProject project) {
        ProjectTargets projectTargets = new ProjectTargets(this, project);
        this.projectMap.put(project, projectTargets);
        return projectTargets;
    }

    protected void deleteTargets(IProject project) {
        IPath targetFilePath = MakeCorePlugin.getDefault().getStateLocation().append(project.getName()).addFileExtension(TARGETS_EXT);
        File targetFile = targetFilePath.toFile();
        if (targetFile.exists()) {
            targetFile.delete();
        }
        this.projectMap.remove(project);
    }

    protected void initializeBuilders() {
        IExtension[] extensions;
        this.builderMap = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.make.core", TARGET_BUILD_EXT);
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] cfgElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = cfgElements = extension.getConfigurationElements();
            int n3 = cfgElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgElement = iConfigurationElementArray[n4];
                if (cfgElement.getName().equals("builder")) {
                    String builderID = cfgElement.getAttribute("builderID");
                    String targetID = cfgElement.getAttribute("id");
                    this.builderMap.put(targetID, builderID);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void notifyListeners(MakeTargetEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMakeTargetListener)listener).targetChanged(event);
            ++n2;
        }
    }

    @Override
    public void addListener(IMakeTargetListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IMakeTargetListener listener) {
        this.listeners.remove(this.listeners);
    }

    @Override
    public String getBuilderID(String targetBuilderID) {
        return this.builderMap.get(targetBuilderID);
    }

    class MakeTargetVisitor
    implements IResourceDeltaVisitor {
        MakeTargetVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                int flags = delta.getFlags();
                int deltaKind = delta.getKind();
                if (deltaKind == 1) {
                    if (MakeTargetManager.this.hasTargetBuilder(project) && !MakeTargetManager.this.fProjects.contains(project)) {
                        MakeTargetManager.this.fProjects.add(project);
                        MakeTargetManager.this.projectMap.remove(project);
                        MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, project));
                    }
                } else if (deltaKind == 2) {
                    if (MakeTargetManager.this.fProjects.contains(project)) {
                        MakeTargetManager.this.deleteTargets(project);
                        MakeTargetManager.this.fProjects.remove(project);
                        MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, project));
                    }
                } else if (deltaKind == 4) {
                    if ((flags & 0x80000) != 0) {
                        if (MakeTargetManager.this.fProjects.contains(project) && !MakeTargetManager.this.hasTargetBuilder(project)) {
                            MakeTargetManager.this.fProjects.remove(project);
                            MakeTargetManager.this.projectMap.remove(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, project));
                        } else if (!MakeTargetManager.this.fProjects.contains(project) && MakeTargetManager.this.hasTargetBuilder(project)) {
                            MakeTargetManager.this.fProjects.add(project);
                            MakeTargetManager.this.projectMap.remove(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, project));
                        }
                    }
                    if ((flags & 0x4000) != 0) {
                        if (!project.isOpen() && MakeTargetManager.this.fProjects.contains(project)) {
                            MakeTargetManager.this.fProjects.remove(project);
                            MakeTargetManager.this.projectMap.remove(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, project));
                        } else if (project.isOpen() && MakeTargetManager.this.hasTargetBuilder(project) && !MakeTargetManager.this.fProjects.contains(project)) {
                            MakeTargetManager.this.fProjects.add(project);
                            MakeTargetManager.this.projectMap.remove(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, project));
                        }
                    }
                }
                return false;
            }
            return resource instanceof IWorkspaceRoot;
        }
    }
}

