/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsElementScanner;

public class SuppressionKindRule
implements IRule {
    private Map<String, List<String>> kinds;
    private IToken token;
    private WordRule subrule;
    private static final IToken DUMMY_TOKEN = new Token(null);
    private static final char[] COLON = new char[]{':'};

    public SuppressionKindRule(Map<String, List<String>> suppKinds, IToken successToken) {
        this.kinds = suppKinds;
        this.token = successToken;
        final ArrayList<String> suppKindsList = new ArrayList<String>();
        for (List<String> entry : suppKinds.values()) {
            suppKindsList.addAll(entry);
        }
        this.subrule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                for (String kind : suppKindsList) {
                    if (c != kind.charAt(0)) continue;
                    return true;
                }
                return false;
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        });
        for (String kind : suppKindsList) {
            this.subrule.addWord(kind, DUMMY_TOKEN);
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken result = this.subrule.evaluate(scanner);
        StringBuilder tool = new StringBuilder();
        StringBuilder kind = new StringBuilder();
        if (!result.isUndefined()) {
            boolean match = true;
            int tokenLength = ((SuppressionsElementScanner)scanner).getTokenLength();
            for (int i = 0; i < tokenLength; ++i) {
                scanner.unread();
            }
            match = this.checkColon(scanner);
            if (match) {
                int preTokenLength = 0;
                while (scanner.getColumn() > 0) {
                    scanner.unread();
                    ++preTokenLength;
                }
                boolean foundChar = false;
                while (preTokenLength-- > 1) {
                    int ch = scanner.read();
                    if (match && !Character.isWhitespace(ch)) {
                        foundChar = true;
                        tool.append(Character.toChars(ch));
                        continue;
                    }
                    if (!foundChar) continue;
                    match = false;
                }
                scanner.read();
                for (int i = 0; i < tokenLength; ++i) {
                    int ch = scanner.read();
                    if (!match) continue;
                    kind.append(Character.toChars(ch));
                }
                if (match) {
                    List<String> kindList = this.kinds.get(tool.toString());
                    if (kindList == null || !kindList.contains(kind.toString())) {
                        match = false;
                    }
                } else {
                    this.unreadBuffer(scanner, tokenLength);
                }
            }
            result = !match ? Token.UNDEFINED : this.token;
        }
        return result;
    }

    private void unreadBuffer(ICharacterScanner scanner, int length) {
        for (int i = 0; i < length; ++i) {
            scanner.unread();
        }
    }

    private boolean checkColon(ICharacterScanner scanner) {
        if (scanner.getColumn() == 0) {
            return false;
        }
        scanner.unread();
        int ch = scanner.read();
        return Arrays.equals(Character.toChars(ch), COLON);
    }
}

