/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageRemovePage
extends WizardPage {
    private static final String NAME = "ImageRemove.name";
    private static final String TITLE = "ImageRemove.title";
    private static final String DESC = "ImageRemove.desc";
    private static final String NAME_LABEL = "ImageRemoveName.label";
    private static final String NAME_TOOLTIP = "ImageRemoveName.toolTip";
    private static final String NAME_EMPTY_RULE = "ErrorRemoveNameEmpty.msg";
    private static final String INVALID_ID = "ErrorRemoveInvalidImageId.msg";
    private Text nameText;
    private List<String> images = new ArrayList<String>();
    private ModifyListener Listener = e -> this.validate();

    public ImageRemovePage() {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    public List<String> getImageNames() {
        return this.images;
    }

    private void validate() {
        String[] names;
        boolean complete = true;
        boolean error = false;
        String nameField = this.nameText.getText().trim();
        ArrayList<String> validNames = new ArrayList<String>();
        if (nameField.length() == 0) {
            this.setErrorMessage(WizardMessages.getString(NAME_EMPTY_RULE));
            error = true;
        }
        for (String name : names = nameField.split("\\s+")) {
            if (name.length() <= 0) continue;
            if (name.charAt(name.length() - 1) == ':') {
                this.setErrorMessage(WizardMessages.getString(INVALID_ID));
                error = true;
            } else if (name.contains(":") && name.substring(name.indexOf(58) + 1).contains(":")) {
                this.setErrorMessage(WizardMessages.getString(INVALID_ID));
                error = true;
            }
            validNames.add(name);
        }
        if (!error) {
            this.setErrorMessage(null);
            this.images = validNames;
        }
        this.setPageComplete(complete && !error);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        Label repoLabel = new Label(container, 0);
        repoLabel.setText(WizardMessages.getString(NAME_LABEL));
        this.nameText = new Text(container, 2052);
        this.nameText.addModifyListener(this.Listener);
        this.nameText.setToolTipText(WizardMessages.getString(NAME_TOOLTIP));
        Point p1 = label.computeSize(-1, -1);
        Point p2 = this.nameText.computeSize(-1, -1);
        int centering = (p2.y - p1.y + 1) / 2;
        FormData f = new FormData();
        f.top = new FormAttachment(0);
        label.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment(0, 0);
        repoLabel.setLayoutData((Object)f);
        f = new FormData();
        f.top = new FormAttachment((Control)label, 11 + centering);
        f.left = new FormAttachment((Control)repoLabel, 5);
        f.right = new FormAttachment(100);
        this.nameText.setLayoutData((Object)f);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }
}

